/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminaluser.local.service.notifier;

import com.biz.crm.mdm.business.terminal.sdk.event.TerminalEventListener;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mdm.business.terminaluser.local.service.TerminalUserRTerminalService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TerminalEventListenerImpl
implements TerminalEventListener {
    @Autowired
    private TerminalUserRTerminalService terminalUserRTerminalService;

    public void onDelete(List<TerminalVo> list) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(list), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> terminalCodeList = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalCode())).map(TerminalVo::getTerminalCode).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(terminalCodeList), (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Integer count = this.terminalUserRTerminalService.countByTerminalCodes(terminalCodeList);
        Validate.isTrue((count < 1 ? 1 : 0) != 0, (String)"\u5bf9\u5e94\u7684\u7ec8\u7aef\u5df2\u5b58\u5728\u5173\u8054\u7684\u7ec8\u7aef\u7528\u6237\u4fe1\u606f\uff0c\u4e0d\u80fd\u6267\u884c\u5220\u9664", (Object[])new Object[0]);
    }
}

