package com.biz.crm.mdm.business.terminaluser.sdk.dto;

import com.biz.crm.mdm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 终端用户与终端关联终端表dto
 *
 * @author sunx
 * @since 2021-10-20 16:38:14
 */
@Data
@ApiModel(value = "TerminalUserRTerminalDto", description = "终端用户与终端关联终端表dto")
public class TerminalUserRTerminalDto extends TenantDto {

  /**
   * 是否是主终端标记
   */
  @ApiModelProperty("是否是主终端标记")
  private Boolean primaryFlag;

  /**
   * 用户编码
   */
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 是否是当前终端标记
   */
  @ApiModelProperty("是否是当前终端标记")
  private Boolean currentFlag;
}

