package com.biz.crm.mdm.business.terminaluser.sdk.vo;

import com.biz.crm.mdm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 终端用户与终端关联终端表vo
 *
 * @author sunx
 * @since 2021-10-20 16:38:15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "终端用户与终端关联终端表Vo")
public class TerminalUserRTerminalVo extends TenantVo {

  /**
   * 是否是主终端标记
   */
  @ApiModelProperty("是否是主终端标记")
  private Boolean primaryFlag;

  /**
   * 用户编码
   */
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 是否是当前终端标记
   */
  @ApiModelProperty("是否是当前终端标记")
  private Boolean currentFlag;
}

