package com.biz.crm.mdm.business.third.system.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.two.center.sdk.dto.StoreEventDto;
import com.biz.crm.mn.third.system.two.center.sdk.service.TwoCenterBusinessService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 第三方系统-双中心
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.15 23:14
 */
@Slf4j
@Api(tags = "第三方系统-双中心扩展")
@RestController
@RequestMapping(value = {"/v1/thirdSystem"})
public class ThirdSystemBusinessController {

    @Autowired(required = false)
    private TwoCenterBusinessService twoCenterBusinessService;


    /**
     * 双中心系统事件通知接口测试
     *
     * @param dto
     * @return com.biz.crm.business.common.sdk.model.Result
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.15 23:13
     */
    @ApiOperation(value = "双中心系统事件通知接口测试")
    @PostMapping(value = {"/twoCenterEventNotice"})
    public Result twoCenterEventNotice(@RequestBody StoreEventDto dto) {
        try {
            if (twoCenterBusinessService != null) {
                this.twoCenterBusinessService.twoCenterEventNotice(dto);
                return Result.ok();
            } else {
                return Result.error("扩展未实现!");
            }
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
