package com.biz.crm.mdm.business.third.system.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictTypeContainDataDto;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictTypeVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeContainDataVo;
import com.biz.crm.mn.common.auth.sdk.aop.SignHeader;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 第三方系统-数据字典接口
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.15 23:14
 */
@Slf4j
@Api(tags = "第三方系统-数据字典接口")
@RestController
@RequestMapping(value = {"/v1/thirdSystem"})
public class ThirdSystemMdmController {

    @Autowired(required = false)
    private DictTypeVoService dictTypeVoService;


    /**
     * 第三方系统-数据字典接口
     *
     * @param dto
     * @return com.biz.crm.business.common.sdk.model.Result
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.15 23:13
     */
    @ApiOperation(value = "数据字典类型列表接口(分页)", httpMethod = "POST")
    @PostMapping(value = {"/listDictTypeContainDataPage"})
    @SignHeader
    public Result<Page<DictTypeContainDataVo>> listDictTypeContainDataPage(@RequestBody DictTypeContainDataDto dto) {
        try {
            Pageable pageable = PageRequest.of(ObjectUtils.defaultIfNull(dto.getPage(), 0), ObjectUtils.defaultIfNull(dto.getSize(), 50));
            Page<DictTypeContainDataVo> result = this.dictTypeVoService.listDictTypeContainDataPage(pageable, dto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
