package com.biz.crm.mdm.business.third.system.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mdm.business.third.system.local.constant.MqConstant;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.two.center.sdk.dto.StoreEventDto;
import com.biz.crm.mn.third.system.two.center.sdk.enums.TwoCenterEventTypeEnum;
import com.biz.crm.mn.third.system.two.center.sdk.service.TwoCenterBusinessService;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.Objects;

/**
 * 双中心系统扩展
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.15 23:07
 */
@Component
@Slf4j
public class TwoCenterBusinessServiceImpl implements TwoCenterBusinessService {


    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    /**
     * 双中心系统事件通知接口 业务实现
     *
     * @param dto 通知参数
     * @return void
     * @describe: 简述
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.1 11:53
     */
    @Override
    public void twoCenterEventNotice(StoreEventDto dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        TwoCenterEventTypeEnum eventTypeEnum = TwoCenterEventTypeEnum.getEnumByCode(dto.getEventCode());
        log.info("双中心事件通知类型[{}]", eventTypeEnum == null ? null : JSON.toJSONString(eventTypeEnum));
        if (Objects.isNull(eventTypeEnum)) {
            return;
        }
        MqMessageVo mqMessageVo = new MqMessageVo();
        mqMessageVo.setMsgBody(JSON.toJSONString(dto));
        switch (eventTypeEnum) {
            case STORE_POI_AUTHED:
            case STORE_POI_AUTH_CANCELED:
            case STORE_LICENCE_AUTHED:
            case STORE_LICENCE_AUTH_CANCELED:
            case STORE_WX_AUTHED:
            case STORE_WX_AUTH_CANCELED:
            case STORE_IDENTITY_AUTHED:
            case STORE_IDENTITY_AUTH_CANCELED:
            case STORE_UPDATED:
            case STORE_CREATED:
            case STORE_CLOSED:
                mqMessageVo.setTopic(MqConstant.MDM_ORDER_TWO_CENTER_TOPIC + RocketMqUtil.mqEnvironment());
                mqMessageVo.setTag(MqConstant.MDM_TWO_CENTER_STORE);
                rocketMqProducer.sendMqOrderMsg(mqMessageVo, StringUtil.isNotBlank(dto.getStoreCode())
                        ? dto.getStoreCode() : MqConstant.MDM_TWO_CENTER_STORE);
                break;
            case EMPLOYEE_CREATED:
            case EMPLOYEE_UPDATED:
            case EMPLOYEE_IDENTITY_AUTHED:
            case EMPLOYEE_IDENTITY_AUTH_CANCELED:
            case EMPLOYEE_WX_AUTHED:
            case EMPLOYEE_WX_AUTH_CANCELED:
            case EMPLOYEE_ENABLED:
            case EMPLOYEE_DISABLED:
            case EMPLOYEE_CANCELED:
                mqMessageVo.setTopic(MqConstant.MDM_ORDER_TWO_CENTER_TOPIC + RocketMqUtil.mqEnvironment());
                mqMessageVo.setTag(MqConstant.MDM_TWO_CENTER_EMPLOYEE);
                rocketMqProducer.sendMqOrderMsg(mqMessageVo, StringUtil.isNotBlank(dto.getEmployeeCode())
                        ? dto.getEmployeeCode() : MqConstant.MDM_TWO_CENTER_EMPLOYEE);
                break;

            case STORE_EMPLOYEE_RELATION_CREATED:
            case STORE_EMPLOYEE_RELATION_UPDATED:
            case STORE_EMPLOYEE_RELATION_DELETED:
                mqMessageVo.setTopic(MqConstant.MDM_ORDER_TWO_CENTER_TOPIC + RocketMqUtil.mqEnvironment());
                mqMessageVo.setTag(MqConstant.MDM_TWO_CENTER_STORE_EMPLOYEE);
                rocketMqProducer.sendMqOrderMsg(mqMessageVo, StringUtil.isNotBlank(dto.getEmployeeCode())
                        ? dto.getEmployeeCode() : MqConstant.MDM_TWO_CENTER_STORE_EMPLOYEE);
                break;
            default:
                throw new IllegalArgumentException(eventTypeEnum.getDesc() +
                        "[" + eventTypeEnum.getCode() + "]未实现业务逻辑!");

        }


    }

}
