package com.biz.crm.mdm.business.third.system.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.dto.TerminalPromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.service.TerminalPromotersVoService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.third.system.local.service.TwoCenterDataUpdateService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.two.center.sdk.dto.StoreEmployeeDto;
import com.biz.crm.mn.third.system.two.center.sdk.dto.StoreEventDto;
import com.biz.crm.mn.third.system.two.center.sdk.dto.StoreQueryDto;
import com.biz.crm.mn.third.system.two.center.sdk.service.TwoCenterApiService;
import com.biz.crm.mn.third.system.two.center.sdk.vo.PromotersVo;
import com.biz.crm.mn.third.system.two.center.sdk.vo.StoreEmployeeVo;
import com.biz.crm.mn.third.system.two.center.sdk.vo.StoreVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/**
 * 双中心系统扩展
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.15 23:07
 */
@Component
@Slf4j
public class TwoCenterDataUpdateServiceImpl implements TwoCenterDataUpdateService {

    @Autowired(required = false)
    private TwoCenterApiService twoCenterApiService;
    @Autowired(required = false)
    private TerminalVoService terminalVoService;
    @Autowired(required = false)
    private PromotersVoService promotersVoService;
    @Autowired(required = false)
    private TerminalPromotersVoService terminalPromotersVoService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 双中心系统门店事件通知接口 业务实现
     *
     * @param dto 通知参数
     * @return void
     * @describe: 简述
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.1 11:53
     */
    @Override
    public void twoCenterStoreEventNotice(StoreEventDto dto) {
        StoreQueryDto storeQueryDto = new StoreQueryDto();
        storeQueryDto.setStoreCode(dto.getStoreCode());
        //门店信息
        List<StoreVo> storeVoList = twoCenterApiService.pullTwoCenterStoreData(storeQueryDto);
        terminalVoService.createOrUpdate(this.buildTerminalList(storeVoList));

    }

    /**
     * 双中系统店员事件通知接口 业务实现
     *
     * @param dto 通知参数
     * @return void
     * @describe: 简述
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.1 11:53
     */
    @Override
    public void twoCenterEmployeeEventNotice(StoreEventDto dto) {
        //更新促销员
        List<PromotersVo> promotersVoList = twoCenterApiService.pullTwoCenterEmployeeData(dto.getEmployeeCode());

        if (CollectionUtil.isNotEmpty(promotersVoList)) {
            List<PromotersDto> promotersDtoList = (List<PromotersDto>) this.nebulaToolkitService.copyCollectionByWhiteList(promotersVoList, PromotersVo.class, PromotersDto.class,
                    HashSet.class,
                    ArrayList.class);
            promotersVoService.createOrUpdate(promotersDtoList);
        }
    }


    /**
     * 双中系统岗店关系事件通知接口 业务实现
     *
     * @param dto 通知参数
     * @return void
     * @describe: 简述
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.1 11:53
     */
    @Override
    public void twoCenterStoreEmployeeEventNotice(StoreEventDto dto) {
        //更新门店和人员关系
        StoreEmployeeDto employeeDto = new StoreEmployeeDto();
        if (StringUtil.isEmpty(dto.getEmployeeCode())
                && StringUtil.isEmpty(dto.getStoreCode())) {
            return;
        }
        employeeDto.setEmployeeCode(dto.getEmployeeCode());
        employeeDto.setStoreCode(dto.getStoreCode());
        String[] includeExtras = new String[]{"hireDate","hireCzDate","empConfireDate",
                "terminationDate","cityLevel","supervisionName","businesserName"};
        employeeDto.setIncludeExtras(includeExtras);
        //岗店关系
        List<StoreEmployeeVo> storeEmployeeVoList = twoCenterApiService.pullTwoCenterStoreEmployeeData(employeeDto);
        terminalPromotersVoService.createOrUpdate(this.buildTerminalPromotersList(storeEmployeeVoList));

    }


    /**
     * 构建门店信息
     *
     * @param storeVoList 双中心系统门店信息
     * @return
     */
    private List<TerminalDto> buildTerminalList(List<StoreVo> storeVoList) {
        if (CollectionUtil.isEmpty(storeVoList)) {
            return Collections.emptyList();
        }
        List<TerminalDto> terminalDtoList = new ArrayList<>(storeVoList.size());
        storeVoList.forEach(storeVo -> {
            TerminalDto terminalDto = new TerminalDto();
            //编码名称
            terminalDto.setTerminalCode(storeVo.getStoreCode());
            terminalDto.setTerminalName(storeVo.getStoreName());
            //经纬度
            try {
                terminalDto.setLongitude(new BigDecimal(storeVo.getLongitude()));
            } catch (Exception e) {
                log.error("", e);
            }
            try {
                terminalDto.setLatitude(new BigDecimal(storeVo.getLatitude()));
            } catch (Exception e) {
                log.error("", e);
            }
            //省
            terminalDto.setProvinceCode(storeVo.getProvinceCode());
            terminalDto.setProvinceName(storeVo.getProvince());
            //市
            terminalDto.setCityCode(storeVo.getCityCode());
            terminalDto.setCityName(storeVo.getCity());
            //区
            terminalDto.setDistrictCode(storeVo.getDistrictCode());
            terminalDto.setDistrictName(storeVo.getDistrict());
            //地址
            terminalDto.setTerminalAddress(storeVo.getStoreAddress());
            if (StringUtils.hasText(storeVo.getCreateTime())) {
                try {
                    terminalDto.setCreateTime(DateUtil.date_yyyy_MM_dd_HH_mm_ss.parse(storeVo.getCreateTime()));
                } catch (Exception e) {
                    log.error("", e);

                }
            }
            if (StringUtils.hasText(storeVo.getModityTime())) {
                try {
                    terminalDto.setCreateTime(DateUtil.date_yyyy_MM_dd_HH_mm_ss.parse(storeVo.getModityTime()));
                } catch (Exception e) {
                    log.error("", e);
                }
            }
            terminalDto.setShopImagePath(storeVo.getFacadeImage());
            terminalDtoList.add(terminalDto);
        });
        return terminalDtoList;
    }


    /**
     * 根据双中心返回信息,构建门店和促销人员关系
     *
     * @param resultDto
     * @return
     */
    private List<TerminalPromotersDto> buildTerminalPromotersList(List<StoreEmployeeVo> resultDto) {
        if (CollectionUtil.isEmpty(resultDto)) {
            return Collections.emptyList();
        }
        List<TerminalPromotersDto> result = new ArrayList<>(resultDto.size());
        String tenantCode = TenantUtils.getTenantCode();
        resultDto.forEach(dto -> {
            TerminalPromotersDto terminalPromotersDto = new TerminalPromotersDto();
            terminalPromotersDto.setCustomerCode(dto.getMarketCode());
            terminalPromotersDto.setEmployeeCode(dto.getEmployeeCode());
            terminalPromotersDto.setTerminalCode(dto.getStoreCode());
            terminalPromotersDto.setStatus(dto.getStatus());
            terminalPromotersDto.setTenantCode(tenantCode);
            result.add(terminalPromotersDto);
        });
        return result;
    }

}
