/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.third.system.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.two.center.sdk.dto.StoreEventDto;
import com.biz.crm.mn.third.system.two.center.sdk.enums.TwoCenterEventTypeEnum;
import com.biz.crm.mn.third.system.two.center.sdk.service.TwoCenterBusinessService;
import java.util.Objects;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TwoCenterBusinessServiceImpl
implements TwoCenterBusinessService {
    private static final Logger log = LoggerFactory.getLogger(TwoCenterBusinessServiceImpl.class);
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    public void twoCenterEventNotice(StoreEventDto dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        TwoCenterEventTypeEnum eventTypeEnum = TwoCenterEventTypeEnum.getEnumByCode((String)dto.getEventCode());
        log.info("\u53cc\u4e2d\u5fc3\u4e8b\u4ef6\u901a\u77e5\u7c7b\u578b[{}]", (Object)(eventTypeEnum == null ? null : JSON.toJSONString((Object)eventTypeEnum)));
        if (Objects.isNull(eventTypeEnum)) {
            return;
        }
        MqMessageVo mqMessageVo = new MqMessageVo();
        mqMessageVo.setMsgBody(JSON.toJSONString((Object)dto));
        switch (eventTypeEnum) {
            case STORE_POI_AUTHED: 
            case STORE_POI_AUTH_CANCELED: 
            case STORE_LICENCE_AUTHED: 
            case STORE_LICENCE_AUTH_CANCELED: 
            case STORE_WX_AUTHED: 
            case STORE_WX_AUTH_CANCELED: 
            case STORE_IDENTITY_AUTHED: 
            case STORE_IDENTITY_AUTH_CANCELED: 
            case STORE_UPDATED: 
            case STORE_CREATED: 
            case STORE_CLOSED: {
                mqMessageVo.setTopic("MDM_ORDER_TWO_CENTER_TOPIC" + RocketMqUtil.mqEnvironment());
                mqMessageVo.setTag("MDM_TWO_CENTER_STORE");
                this.rocketMqProducer.sendMqOrderMsg(mqMessageVo, StringUtil.isNotBlank((CharSequence)dto.getStoreCode()) ? dto.getStoreCode() : "MDM_TWO_CENTER_STORE");
                break;
            }
            case EMPLOYEE_CREATED: 
            case EMPLOYEE_UPDATED: 
            case EMPLOYEE_IDENTITY_AUTHED: 
            case EMPLOYEE_IDENTITY_AUTH_CANCELED: 
            case EMPLOYEE_WX_AUTHED: 
            case EMPLOYEE_WX_AUTH_CANCELED: 
            case EMPLOYEE_ENABLED: 
            case EMPLOYEE_DISABLED: 
            case EMPLOYEE_CANCELED: {
                mqMessageVo.setTopic("MDM_ORDER_TWO_CENTER_TOPIC" + RocketMqUtil.mqEnvironment());
                mqMessageVo.setTag("MDM_TWO_CENTER_EMPLOYEE");
                this.rocketMqProducer.sendMqOrderMsg(mqMessageVo, StringUtil.isNotBlank((CharSequence)dto.getEmployeeCode()) ? dto.getEmployeeCode() : "MDM_TWO_CENTER_EMPLOYEE");
                break;
            }
            case STORE_EMPLOYEE_RELATION_CREATED: 
            case STORE_EMPLOYEE_RELATION_UPDATED: 
            case STORE_EMPLOYEE_RELATION_DELETED: {
                mqMessageVo.setTopic("MDM_ORDER_TWO_CENTER_TOPIC" + RocketMqUtil.mqEnvironment());
                mqMessageVo.setTag("MDM_TWO_CENTER_STORE_EMPLOYEE");
                this.rocketMqProducer.sendMqOrderMsg(mqMessageVo, StringUtil.isNotBlank((CharSequence)dto.getEmployeeCode()) ? dto.getEmployeeCode() : "MDM_TWO_CENTER_STORE_EMPLOYEE");
                break;
            }
            default: {
                throw new IllegalArgumentException(eventTypeEnum.getDesc() + "[" + eventTypeEnum.getCode() + "]\u672a\u5b9e\u73b0\u4e1a\u52a1\u903b\u8f91!");
            }
        }
    }
}

