/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.third.system.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.dto.TerminalPromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.service.TerminalPromotersVoService;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.third.system.local.service.TwoCenterDataUpdateService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.two.center.sdk.dto.StoreEmployeeDto;
import com.biz.crm.mn.third.system.two.center.sdk.dto.StoreEventDto;
import com.biz.crm.mn.third.system.two.center.sdk.dto.StoreQueryDto;
import com.biz.crm.mn.third.system.two.center.sdk.service.TwoCenterApiService;
import com.biz.crm.mn.third.system.two.center.sdk.vo.PromotersVo;
import com.biz.crm.mn.third.system.two.center.sdk.vo.StoreEmployeeVo;
import com.biz.crm.mn.third.system.two.center.sdk.vo.StoreVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TwoCenterDataUpdateServiceImpl
implements TwoCenterDataUpdateService {
    private static final Logger log = LoggerFactory.getLogger(TwoCenterDataUpdateServiceImpl.class);
    @Autowired(required=false)
    private TwoCenterApiService twoCenterApiService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private PromotersVoService promotersVoService;
    @Autowired(required=false)
    private TerminalPromotersVoService terminalPromotersVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public void twoCenterStoreEventNotice(StoreEventDto dto) {
        StoreQueryDto storeQueryDto = new StoreQueryDto();
        storeQueryDto.setStoreCode(dto.getStoreCode());
        List storeVoList = this.twoCenterApiService.pullTwoCenterStoreData(storeQueryDto);
        this.terminalVoService.createOrUpdate(this.buildTerminalList(storeVoList));
    }

    @Override
    public void twoCenterEmployeeEventNotice(StoreEventDto dto) {
        List promotersVoList = this.twoCenterApiService.pullTwoCenterEmployeeData(dto.getEmployeeCode());
        if (CollectionUtil.isNotEmpty((Collection)promotersVoList)) {
            List promotersDtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)promotersVoList, PromotersVo.class, PromotersDto.class, HashSet.class, ArrayList.class, new String[0]);
            this.promotersVoService.createOrUpdate(promotersDtoList);
        }
    }

    @Override
    public void twoCenterStoreEmployeeEventNotice(StoreEventDto dto) {
        StoreEmployeeDto employeeDto = new StoreEmployeeDto();
        if (StringUtil.isEmpty((CharSequence)dto.getEmployeeCode()) && StringUtil.isEmpty((CharSequence)dto.getStoreCode())) {
            return;
        }
        employeeDto.setEmployeeCode(dto.getEmployeeCode());
        employeeDto.setStoreCode(dto.getStoreCode());
        String[] includeExtras = new String[]{"hireDate", "hireCzDate", "empConfireDate", "terminationDate", "cityLevel", "supervisionName", "businesserName"};
        employeeDto.setIncludeExtras(includeExtras);
        List storeEmployeeVoList = this.twoCenterApiService.pullTwoCenterStoreEmployeeData(employeeDto);
        this.terminalPromotersVoService.createOrUpdate(this.buildTerminalPromotersList(storeEmployeeVoList));
    }

    private List<TerminalDto> buildTerminalList(List<StoreVo> storeVoList) {
        if (CollectionUtil.isEmpty(storeVoList)) {
            return Collections.emptyList();
        }
        ArrayList<TerminalDto> terminalDtoList = new ArrayList<TerminalDto>(storeVoList.size());
        storeVoList.forEach(storeVo -> {
            TerminalDto terminalDto = new TerminalDto();
            terminalDto.setTerminalCode(storeVo.getStoreCode());
            terminalDto.setTerminalName(storeVo.getStoreName());
            try {
                terminalDto.setLongitude(new BigDecimal(storeVo.getLongitude()));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            try {
                terminalDto.setLatitude(new BigDecimal(storeVo.getLatitude()));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            terminalDto.setProvinceCode(storeVo.getProvinceCode());
            terminalDto.setProvinceName(storeVo.getProvince());
            terminalDto.setCityCode(storeVo.getCityCode());
            terminalDto.setCityName(storeVo.getCity());
            terminalDto.setDistrictCode(storeVo.getDistrictCode());
            terminalDto.setDistrictName(storeVo.getDistrict());
            terminalDto.setTerminalAddress(storeVo.getStoreAddress());
            if (StringUtils.hasText((String)storeVo.getCreateTime())) {
                try {
                    terminalDto.setCreateTime(DateUtil.date_yyyy_MM_dd_HH_mm_ss.parse(storeVo.getCreateTime()));
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
            if (StringUtils.hasText((String)storeVo.getModityTime())) {
                try {
                    terminalDto.setCreateTime(DateUtil.date_yyyy_MM_dd_HH_mm_ss.parse(storeVo.getModityTime()));
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
            terminalDto.setShopImagePath(storeVo.getFacadeImage());
            terminalDtoList.add(terminalDto);
        });
        return terminalDtoList;
    }

    private List<TerminalPromotersDto> buildTerminalPromotersList(List<StoreEmployeeVo> resultDto) {
        if (CollectionUtil.isEmpty(resultDto)) {
            return Collections.emptyList();
        }
        ArrayList<TerminalPromotersDto> result = new ArrayList<TerminalPromotersDto>(resultDto.size());
        String tenantCode = TenantUtils.getTenantCode();
        resultDto.forEach(dto -> {
            TerminalPromotersDto terminalPromotersDto = new TerminalPromotersDto();
            terminalPromotersDto.setCustomerCode(dto.getMarketCode());
            terminalPromotersDto.setEmployeeCode(dto.getEmployeeCode());
            terminalPromotersDto.setTerminalCode(dto.getStoreCode());
            terminalPromotersDto.setStatus(dto.getStatus());
            terminalPromotersDto.setTenantCode(tenantCode);
            result.add(terminalPromotersDto);
        });
        return result;
    }
}

