package com.biz.crm.mdm.business.user.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.feign.feign.UserPositionVoFeign;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 用户信息feign接口熔断类
 *
 * @author songjingen
 * @date 2022/3/2
 */
@Slf4j
@Component
public class UserPositionVoFeignFallbackImpl implements FallbackFactory<UserPositionVoFeign> {
  @Override
  public UserPositionVoFeign create(Throwable throwable) {
    return new UserPositionVoFeign() {

      @Override
      public Result<List<UserPositionVo>> findByUserName(String tenantCode, String userName) {
        throw new UnsupportedOperationException("根据用户账号查询职位-用户关系熔断");
      }

    };
  }
}
