package com.biz.crm.mdm.business.user.feign.service.internal;

import com.biz.crm.business.common.sdk.constant.CommonConstant;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.feign.feign.UserValidityCheckFeign;
import com.biz.crm.mdm.business.user.sdk.service.UserValidityCheckService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 用户有效性检查Feign服务实现
 *
 * @author pengxi
 */
@Service
public class UserValidityCheckServiceImpl implements UserValidityCheckService {

  @Autowired(required = false)
  private UserValidityCheckFeign userValidityCheckFeign;

  @Override
  public UserVo verificationManageByAccount(String account) {
    Result<UserVo> userVoResult = this.userValidityCheckFeign.verificationManageByAccount(account);
    if (!CommonConstant.SC_OK_200.equals(userVoResult.getCode())) {
      throw new RuntimeException(userVoResult.getMessage());
    }
    return userVoResult.getResult();
  }

  @Override
  public UserVo verificationManageByPhone(String phone) {
    Result<UserVo> userVoResult = this.userValidityCheckFeign.verificationManageByPhone(phone);
    if (!CommonConstant.SC_OK_200.equals(userVoResult.getCode())) {
      throw new RuntimeException(userVoResult.getMessage());
    }
    return userVoResult.getResult();
  }

  @Override
  public UserVo verificationManageByOpenid(String openid) {
    Result<UserVo> userVoResult = this.userValidityCheckFeign.verificationManageByOpenid(openid);
    if (!CommonConstant.SC_OK_200.equals(userVoResult.getCode())) {
      throw new RuntimeException(userVoResult.getMessage());
    }
    return userVoResult.getResult();
  }
}
