/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.feign.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.feign.feign.UserRelDingTalkVoFeign;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelDingTalkDto;
import com.biz.crm.mdm.business.user.sdk.service.UserRelDingTalkVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="FeignUserRelDingTalkVoServiceImpl")
public class UserRelDingTalkVoServiceImpl
implements UserRelDingTalkVoService {
    @Autowired(required=false)
    private UserRelDingTalkVoFeign userRelDingTalkVoFeign;

    @Transactional(rollbackFor={Exception.class})
    public List<UserRelDingTalkVo> createBatch(List<UserRelDingTalkDto> dtoList) {
        this.createValidation(dtoList);
        Result<List<UserRelDingTalkVo>> result = this.userRelDingTalkVoFeign.createBatch(dtoList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    private void createValidation(List<UserRelDingTalkDto> dtoList) {
        Assert.notEmpty(dtoList, (String)"\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        dtoList.forEach(dto -> {
            Assert.hasLength((String)dto.getUserName(), (String)"\u8d26\u53f7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.hasLength((String)dto.getDingTalkUserId(), (String)"\u9489\u9489ID\u4e0d\u80fd\u4e3a\u7a7a!");
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<String> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        Result<?> result = this.userRelDingTalkVoFeign.deleteByIds(ids);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByUserNames(List<String> userNameList) {
        if (CollectionUtil.isEmpty(userNameList)) {
            return;
        }
        Result<?> result = this.userRelDingTalkVoFeign.deleteByUserNames(userNameList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByDingTalkUserIds(List<String> dingTalkUserIds) {
        if (CollectionUtil.isEmpty(dingTalkUserIds)) {
            return;
        }
        Result<?> result = this.userRelDingTalkVoFeign.deleteByDingTalkUserIds(dingTalkUserIds);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
    }

    public UserRelDingTalkVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Result<UserRelDingTalkVo> result = this.userRelDingTalkVoFeign.findById(id);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (UserRelDingTalkVo)result.getResult();
    }

    public List<UserRelDingTalkVo> findByDingTalkUserId(String dingTalkUserId) {
        if (StringUtils.isBlank((CharSequence)dingTalkUserId)) {
            return null;
        }
        Result<List<UserRelDingTalkVo>> result = this.userRelDingTalkVoFeign.findByDingTalkUserId(dingTalkUserId);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public List<UserRelDingTalkVo> findByDingTalkUserIds(List<String> dingTalkUserIds) {
        if (CollectionUtil.isEmpty(dingTalkUserIds)) {
            return null;
        }
        Result<List<UserRelDingTalkVo>> result = this.userRelDingTalkVoFeign.findByDingTalkUserIds(dingTalkUserIds);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public List<UserRelDingTalkVo> findByUserName(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return Collections.emptyList();
        }
        Result<List<UserRelDingTalkVo>> result = this.userRelDingTalkVoFeign.findByUserName(userName);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public List<UserRelDingTalkVo> findByUserNames(List<String> userNameList) {
        if (CollectionUtil.isEmpty(userNameList)) {
            return Collections.emptyList();
        }
        Result<List<UserRelDingTalkVo>> result = this.userRelDingTalkVoFeign.findByUserNames(userNameList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public Map<String, Set<String>> findMapByUserNames(List<String> userNameList) {
        if (CollectionUtil.isEmpty(userNameList)) {
            return Collections.emptyMap();
        }
        Result<Map<String, Set<String>>> result = this.userRelDingTalkVoFeign.findMapByUserNames(userNameList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (Map)result.getResult();
    }

    public Set<String> findDingTalkUserIdByUserName(String userName) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            return Collections.emptySet();
        }
        Result<Set<String>> result = this.userRelDingTalkVoFeign.findDingTalkUserIdByUserName(userName);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (Set)result.getResult();
    }

    public Set<String> findDingTalkUserIdByUserNames(List<String> userNameList) {
        if (CollectionUtil.isEmpty(userNameList)) {
            return Collections.emptySet();
        }
        Result<Set<String>> result = this.userRelDingTalkVoFeign.findDingTalkUserIdByUserNames(userNameList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (Set)result.getResult();
    }
}

