package com.biz.crm.mdm.business.user.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.feign.feign.internal.UserRelWeChatVoFeignFallbackImpl;
import com.biz.crm.mdm.business.user.sdk.dto.UserWeChatBindDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 用户绑定微信feign接口类
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@FeignClient(
    name = "${feign.urlip:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = UserRelWeChatVoFeignFallbackImpl.class
)
public interface UserRelWeChatVoFeign {

  /**
   * 通过用用户与微信关系
   *
   * @param dto 参数dto
   */
  @PostMapping("/v1/userRelWeChat/userRelWeChat/createByUserWeChatBindDto")
  Result createByUserWeChatBindDto(@RequestBody UserWeChatBindDto dto);
}
