package com.biz.crm.mdm.business.user.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.feign.feign.internal.UserValidityCheckFeignFallbackImpl;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 用户信息feign接口类
 *
 * @author pengxi
 */
@FeignClient(
    name = "${feign.urlip:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = UserValidityCheckFeignFallbackImpl.class
)
public interface UserValidityCheckFeign {

  /**
   * 根据账号校验【管理端】用户有效性
   *
   * @param account 账号
   * @return UserVo 用户信息
   */
  @ApiOperation(value = "根据账号校验【管理端】用户有效性")
  @GetMapping(value = {"/v1/userValidityCheck/userValidityCheck/findByAccount"})
  Result<UserVo> verificationManageByAccount(@RequestParam("account") String account);

  /**
   * 根据手机号校验【管理端】用户有效性
   *
   * @param phone 手机号
   * @return UserVo 用户信息
   */
  @ApiOperation(value = "根据手机号校验【管理端】用户有效性")
  @GetMapping(value = {"/v1/userValidityCheck/userValidityCheck/findByPhone"})
  Result<UserVo> verificationManageByPhone(@RequestParam("phone") String phone);

  /**
   * 根据openid校验【管理端】用户有效性
   *
   * @param openid openid
   * @return UserVo 用户信息
   */
  @ApiOperation(value = "根据openid校验【管理端】用户有效性")
  @GetMapping(value = {"/v1/userValidityCheck/userValidityCheck/findByOpenid"})
  Result<UserVo> verificationManageByOpenid(@RequestParam("openid") String openid);
}
