package com.biz.crm.mdm.business.user.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.user.feign.feign.UserVoFeign;
import com.biz.crm.mdm.business.user.sdk.dto.UserChangePasswordDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserForceChangePasswordDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserPageDto;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * 用户信息服务接口实现类
 *
 * @author songjingen
 * @date 2022/3/2
 */
@Service("FeignUserVoServiceImpl")
public class UserVoServiceImpl implements UserVoService {

  @Autowired(required = false)
  private UserVoFeign userVoFeign;

  @Override
  public Set<String> findUserNamesByCodesAndUserType(List<String> orgCodes, List<String> positionLevelCodes, String userType) {
    return this.userVoFeign.findUserNamesByCodesAndUserType(orgCodes, positionLevelCodes, userType).checkFeignResult();
  }

  @Override
  public UserVo findDetailsByPhone(String phone) {
    return this.userVoFeign.findDetailsByPhone(phone).checkFeignResult();
  }

  @Override
  public UserVo findByPhone(String phone) {
    throw new UnsupportedOperationException();
  }

  @Override
  public Page<UserVo> findByConditions(Pageable pageable, UserPageDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public UserVo findDetailById(String id) {
    throw new UnsupportedOperationException();
  }

  @Override
  public UserVo findByUserName(String userName) {
    return this.userVoFeign.findByUserName(userName).checkFeignResult();
  }

  @Override
  public void create(UserDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void update(UserDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void enableBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void disableBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void updateDelFlagByIds(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void deleteUserLockByIds(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void updatePasswordByIds(UserForceChangePasswordDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void updatePasswordByUserName(UserChangePasswordDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public UserVo findRelationByUserNameAndOrgCodesOrOrgTypes(String userName, List<String> orgCodes, List<String> orgTypes) {
    return this.userVoFeign.findRelationByUserNameAndOrgCodesOrOrgTypes(userName, orgCodes, orgTypes).checkFeignResult();
  }

  @Override
  public Set<String> findUserNamesByUserConditionDto(UserConditionDto dto) {
    return this.userVoFeign.findUserNamesByUserConditionDto(dto).checkFeignResult();
  }

  @Override
  public Set<String> findPositionCodesByUserNames(List<String> userNames) {
    return this.userVoFeign.findPositionCodesByUserNames(userNames).checkFeignResult();
  }
}
