package com.biz.crm.mdm.business.user.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.feign.feign.UserValidityCheckFeign;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 用户信息feign接口熔断类
 *
 * @author songjingen
 * @date 2022/3/2
 */
@Slf4j
@Component
public class UserValidityCheckFeignFallbackImpl implements FallbackFactory<UserValidityCheckFeign> {

  @Override
  public UserValidityCheckFeign create(Throwable cause) {
    return new UserValidityCheckFeign() {
      @Override
      public Result<UserVo> verificationManageByAccount(String account) {
        throw new UnsupportedOperationException("根据账号校验【管理端】用户有效性熔断");
      }

      @Override
      public Result<UserVo> verificationManageByPhone(String phone) {
        throw new UnsupportedOperationException("根据手机号校验【管理端】用户有效性熔断");
      }

      @Override
      public Result<UserVo> verificationManageByOpenid(String openid) {
        throw new UnsupportedOperationException("根据openid校验【管理端】用户有效性熔断");
      }
    };
  }
}
