package com.biz.crm.mdm.business.user.feign.service.internal;

import com.biz.crm.mdm.business.user.feign.feign.UserInfoVoFeign;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * 用户信息服务接口实现类
 *
 * @author songjingen
 * @date 2022/3/2
 */
@Service("FeignUserInfoVoServiceImpl")
public class UserInfoVoServiceImpl implements UserInfoVoService {

  @Autowired(required = false)
  private UserInfoVoFeign userInfoVoFeign;

  @Override
  public List<UserInfoVo> findByPositionCodes(Set<String> positionCodes) {
    return this.userInfoVoFeign.findByPositionCodes(positionCodes).getResult();
  }

  @Override
  public List<UserInfoVo> findByLotPositionCodes(Set<String> positionCodes) {
    return this.userInfoVoFeign.findByLotPositionCodes(positionCodes).getResult();
  }

  @Override
  public List<UserInfoVo> findByUserNames(Set<String> userNames) {
    return this.userInfoVoFeign.findByUserNames(userNames).getResult();
  }

}
