package com.biz.crm.mdm.business.user.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.feign.feign.internal.UserInfoVoFeignFallbackImpl;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Set;

/**
 * 用户信息feign接口类
 *
 * @author songjingen
 * @date 2022/3/2
 */
@FeignClient(
    name = "${feign.urlip:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = UserInfoVoFeignFallbackImpl.class
)
public interface UserInfoVoFeign {

  /**
   * 根据职位集合查询用户信息
   *
   * @param positionCodes 职位集合
   * @return
   */
  @ApiOperation(value = "根据职位集合查询用户信息")
  @GetMapping(value = {"/v1/userInfo/userInfo/findByPositionCodes"})
  Result<List<UserInfoVo>> findByPositionCodes(@RequestParam("positionCodes") Set<String> positionCodes);

  /**
   * 根据大量职位集合查询
   *
   * @param positionCodes 职位集合
   * @return
   */
  @ApiOperation(value = "根据大量职位集合查询")
  @PostMapping(value = {"/v1/userInfo/userInfo/findByLotPositionCodes"})
  Result<List<UserInfoVo>> findByLotPositionCodes(@RequestBody Set<String> positionCodes);
  /**
   * 根据用户账号集合查询
   *
   * @param userNames 用户账号集合
   * @return
   */
  @ApiOperation(value = "根据用户账号集合查询")
  @GetMapping(value = {"/v1/userInfo/userInfo/findByUserNames"})
  Result<List<UserInfoVo>> findByUserNames(@RequestParam("userNames") Set<String> userNames);

}
