package com.biz.crm.mdm.business.user.local.authority;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import org.springframework.stereotype.Component;

/**
 * @Author: heguanyun
 * @Date: 2022/4/14 19:18
 * @description:
 */
@Component("userSelectAuthorityModeRegister")
public class UserAuthorityModeRegister implements SelectAuthorityModeRegister {
  @Override
  public String modeKey() {
    return "userAuthorityModeRegister";
  }

  @Override
  public String modeName() {
    return "查看当前登录人账号创建的数据";
  }

  @Override
  public String controlKey() {
    return "userAuthorityModeRegister";
  }

  @Override
  public int sort() {
    return 9;
  }

  @Override
  public String groupCode() {
    return "user_group";
  }

  @Override
  public boolean isArrayValue() {
    return false;
  }

  @Override
  public boolean isStaticValue() {
    return false;
  }

  @Override
  public Class<?> modeValueClass() {
    return String.class;
  }

  @Override
  public Object staticValue(String[] strings) {
    return null;
  }

  @Override
  public Object dynamicValue(LoginDetails loginDetails, String s) {
    //如果不是后台管理用户，就不按职位字段进行权限控制
    if (!(loginDetails instanceof LoginUserDetails)) {
      return null;
    }
    LoginUserDetails loginUserDetails = (LoginUserDetails) loginDetails;
    return loginUserDetails.getAccount();
  }

  @Override
  public String converterKey() {
    return "chartEqualMarsAuthorityValueAstConverter";
  }
}
