package com.biz.crm.mdm.business.user.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelDingTalkDto;
import com.biz.crm.mdm.business.user.sdk.service.UserRelDingTalkVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 用户与钉钉关联表(UserRelDingTalk)表控制层
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.3 23:15
 */
@Slf4j
@Api(tags = "企业用户：UserRelDingTalkVo：用户与钉钉关联表")
@RestController
@RequestMapping(value = {"/v1/userRelDingTalk/UserRelDingTalkVo"})
public class UserRelDingTalkVoController {

    @Autowired(required = false)
    private UserRelDingTalkVoService dingTalkVoService;

    @ApiOperation(value = "创建")
    @PostMapping(value = "createBatch")
    public Result<List<UserRelDingTalkVo>> createBatch(@RequestBody List<UserRelDingTalkDto> dto) {
        try {
            List<UserRelDingTalkVo> result = this.dingTalkVoService.createBatch(dto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    @ApiOperation(value = "根据ID集合移除")
    @DeleteMapping("/deleteByIds")
    public Result<?> deleteByIds(@RequestParam("ids") List<String> ids) {
        try {
            this.dingTalkVoService.deleteByIds(ids);
            return Result.ok("解绑成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据用户账号移除")
    @DeleteMapping("/deleteByUserNames")
    public Result<?> deleteByUserNames(@RequestParam("userNames") List<String> userNames) {
        try {
            this.dingTalkVoService.deleteByUserNames(userNames);
            return Result.ok("解绑成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据钉钉ID集合移除")
    @DeleteMapping("/deleteByDingTalkUserIds")
    public Result<?> deleteByDingTalkUserIds(@RequestParam("dingTalkUserIds") List<String> dingTalkUserIds) {
        try {
            this.dingTalkVoService.deleteByDingTalkUserIds(dingTalkUserIds);
            return Result.ok("解绑成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据iD获取用户和钉钉关系详情")
    @GetMapping(value = {"/findById"})
    public Result<UserRelDingTalkVo> findById(@RequestParam("id") String id) {
        try {
            UserRelDingTalkVo vo = this.dingTalkVoService.findById(id);
            return Result.ok(vo);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据钉钉ID获取用户和钉钉关系列表")
    @GetMapping(value = {"/findByDingTalkUserId"})
    public Result<List<UserRelDingTalkVo>> findByDingTalkUserId(@RequestParam("dingTalkUserId") String dingTalkUserId) {
        try {
            List<UserRelDingTalkVo> result = this.dingTalkVoService.findByDingTalkUserId(dingTalkUserId);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据钉钉ID集合获取用户和钉钉关系列表")
    @GetMapping(value = {"/findByDingTalkUserIds"})
    public Result<List<UserRelDingTalkVo>> findByDingTalkUserIds(@RequestParam("dingTalkUserIds") List<String> dingTalkUserIds) {
        try {
            List<UserRelDingTalkVo> result = this.dingTalkVoService.findByDingTalkUserIds(dingTalkUserIds);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据账号获取用户和钉钉关系列表")
    @GetMapping(value = {"/findByUserName"})
    public Result<List<UserRelDingTalkVo>> findByUserName(@RequestParam("userName") String userName) {
        try {
            List<UserRelDingTalkVo> result = this.dingTalkVoService.findByUserName(userName);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据账号集合获取用户和钉钉关系列表")
    @GetMapping(value = {"/findByUserNames"})
    public Result<List<UserRelDingTalkVo>> findByUserNames(@RequestParam("userNames") List<String> userNames) {
        try {
            List<UserRelDingTalkVo> result = this.dingTalkVoService.findByUserNames(userNames);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据账号集合获取用户关联钉钉信息
     * key userName
     * value 钉钉用户ID Set
     *
     * @param userNames 账号集合
     * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    @ApiOperation(value = "根据账号集合获取用户关联钉钉信息")
    @GetMapping(value = {"/findMapByUserNames"})
    public Result<Map<String, Set<String>>> findMapByUserNames(@RequestParam("userNames") List<String> userNames) {
        try {
            Map<String, Set<String>> result = this.dingTalkVoService.findMapByUserNames(userNames);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    @ApiOperation(value = "根据账号获取用户和钉钉用户ID信息")
    @GetMapping(value = {"/findDingTalkUserIdByUserName"})
    public Result<Set<String>> findDingTalkUserIdByUserName(@RequestParam("userNames") String userName) {
        try {
            Set<String> result = this.dingTalkVoService.findDingTalkUserIdByUserName(userName);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据账号集合获取用户和钉钉用户ID信息")
    @GetMapping(value = {"/findDingTalkUserIdByUserNames"})
    public Result<Set<String>> findDingTalkUserIdByUserNames(@RequestParam("userNames") List<String> userNames) {
        try {
            Set<String> result = this.dingTalkVoService.findDingTalkUserIdByUserNames(userNames);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
