package com.biz.crm.mdm.business.user.local.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 企业用户数据视图
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.5 13:24
 */
@Component
public class UserDateViewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "mdm_user_data_view";
    }

    @Override
    public String desc() {
        return "MDM 企业用户数据视图";
    }

    @Override
    public String buildSql() {
        return "SELECT " +
                " u.*, " +
                " o.org_name, " +
                " o.org_code, " +
                " pl.position_level_code, " +
                " pl.position_level_name, " +
                " p.position_code, " +
                " p.position_name " +
                " FROM mdm_user u " +
                " LEFT JOIN mdm_user_position t1 ON t1.tenant_code = u.tenant_code AND t1.user_name = u.user_name AND t1.primary_flag='1'" +
                " LEFT JOIN mdm_position p ON p.tenant_code = t1.tenant_code AND p.position_code = t1.position_code" +
                " LEFT JOIN mdm_position_level pl ON pl.tenant_code = p.tenant_code AND p.position_level_code = pl.position_level_code" +
                " LEFT JOIN mdm_org_position op ON op.tenant_code = p.tenant_code AND op.position_code = p.position_code" +
                " LEFT JOIN mdm_org o ON o.tenant_code = op.tenant_code AND o.org_code = op.org_code" +
                " WHERE u.del_flag='" + DelFlagStatusEnum.NORMAL.getCode() + "' and u.user_type in ('u', 'user_guide') and u.tenant_code= :tenantCode and o.rule_code like concat(:ruleCode,'%')";
    }
}