package com.biz.crm.mdm.business.user.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;


/**
 * 用户与钉钉关联表(UserRelDingTalkEntity)实体类
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.3 21:46
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName(value = "mdm_user_rel_ding_talk")
@Table(
        name = "mdm_user_rel_ding_talk",
        indexes = {
                @Index(name = "mdm_user_rel_ding_talk_index1", unique = false, columnList = "user_name"),
                @Index(name = "mdm_user_rel_ding_talk_index2", unique = false, columnList = "ding_talk_user_id"),
        })
@org.hibernate.annotations.Table(appliesTo = "mdm_user_rel_ding_talk", comment = "用户与钉钉关联表")
public class UserRelDingTalkEntity extends TenantFlagOpEntity {

    private static final long serialVersionUID = 1387457615096408293L;

    @ApiModelProperty("用户登录名")
    @TableField(value = "user_name")
    @Column(name = "user_name", length = 32, columnDefinition = "varchar(32) COMMENT '用户登录名'")
    private String userName;

    @ApiModelProperty("钉钉用户ID")
    @TableField(value = "ding_talk_user_id")
    @Column(name = "ding_talk_user_id", length = 32, columnDefinition = "varchar(32) COMMENT '钉钉用户ID'")
    private String dingTalkUserId;

    @ApiModelProperty("钉钉员工姓名")
    @TableField(value = "ding_talk_name")
    @Column(name = "ding_talk_name", length = 128, columnDefinition = "varchar(128) COMMENT '钉钉员工姓名'")
    private String dingTalkName;

    @ApiModelProperty("钉钉职位")
    @TableField(value = "ding_talk_title")
    @Column(name = "ding_talk_title", length = 128, columnDefinition = "varchar(128) COMMENT '钉钉职位'")
    private String dingTalkTitle;

    @ApiModelProperty("钉钉手机号码")
    @TableField(value = "mobile")
    @Column(name = "mobile", length = 11, columnDefinition = "varchar(11) COMMENT '钉钉手机号码'")
    private String mobile;

    @ApiModelProperty("是否完成了实名认证;true：已认证;false：未认证")
    @TableField(value = "real_authed")
    @Column(name = "real_authed", length = 1, columnDefinition = "varchar(1) COMMENT '是否完成了实名认证;true：已认证;false：未认证'")
    private Boolean realAuthed;

}
