package com.biz.crm.mdm.business.user.local.event;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.user.sdk.event.UserEventListener;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author yangshen
 * @version 1.0
 * @date 2022/12/28 18:25
 * @ClassName UserLogEventListener
 * @Description TODO 企业用户日志事件监听器
 */
@Component
public class UserLogEventListener implements UserEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 创建时生效
     * @param vo
     */
    @Override
    public void onCreate(UserVo vo) {
        String onlyKey = vo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(null);
        crmBusinessLogDto.setNewObject(vo);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 更新时生效
     * @param oldVo
     * @param newVo
     */
    @Override
    public void onUpdate(UserVo oldVo, UserVo newVo) {
        String onlyKey = newVo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(oldVo);
        crmBusinessLogDto.setNewObject(newVo);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 开启时生效
     * @param list 旧数据
     */
    @Override
    public void onEnable(List<UserVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(userVo -> {
            String onlyKey = userVo.getId();
            UserVo oldObj = new UserVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(userVo.getEnableStatus());
            UserVo newObj = new UserVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            this.onUpdate(oldObj,newObj);
        });
    }

    /**
     * 禁用时生效
     * @param list 旧数据
     */
    @Override
    public void onDisable(List<UserVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(userVo -> {
            String onlyKey = userVo.getId();
            UserVo oldObj = new UserVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(userVo.getEnableStatus());
            UserVo newObj = new UserVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            this.onUpdate(oldObj,newObj);
        });
    }

    /**
     * 删除时生效
     * @param list
     */
    @Override
    public void onDelete(List<UserVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(userVo -> {
            String onlyKey = userVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(userVo);
            crmBusinessLogDto.setNewObject(null);
            crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }
}
