package com.biz.crm.mdm.business.user.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.user.local.entity.UserRelWeChatEntity;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelWeChatPageDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelWeChatVo;
import org.apache.ibatis.annotations.Param;

/**
 * 用户与微信关联表(UserRelWeChat)表数据库访问层
 *
 * @author xi.peng
 * @since 2021-11-05 15:05:07
 */
public interface UserRelWeChatMapper extends BaseMapper<UserRelWeChatEntity> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<UserRelWeChatVo> findByConditions(Page<UserRelWeChatPageDto> page, @Param("dto") UserRelWeChatPageDto dto);

}

