package com.biz.crm.mdm.business.user.local.service;

import com.biz.crm.mdm.business.user.local.entity.UserPositionEntity;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;

import java.util.Collection;
import java.util.List;

/**
 * 职位-用户关联表(UserPosition)表服务接口
 *
 * @author xi.peng
 * @since 2021-11-05 15:11:43
 */
public interface UserPositionService {

  /**
   * 根据职位编码查询
   *
   * @param positionCodes
   * @return
   */
  List<UserPositionEntity> findByPositionCode(Collection<String> positionCodes);

  /**
   * 根据用户编码批量查询用户职位关系
   *
   * @author huojia
   * @date 2022/12/24 15:41
   * @param userNameList
   * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo>
   **/
  List<UserPositionVo> listByUserNameList(List<String> userNameList);
}
