package com.biz.crm.mdm.business.user.local.service.internal;

import com.biz.crm.mdm.business.user.local.entity.UserPositionEntity;
import com.biz.crm.mdm.business.user.local.repository.UserPositionRepository;
import com.biz.crm.mdm.business.user.local.service.UserPositionService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * 职位-用户关联表(UserPosition)表服务实现类
 *
 * @author xi.peng
 * @since 2021-11-05 15:02:58
 */
@Service
public class UserPositionServiceImpl implements UserPositionService {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  
  @Autowired(required = false)
  private UserPositionRepository userPositionRepository;

  @Override
  public List<UserPositionEntity> findByPositionCode(Collection<String> positionCodes) {
    if (CollectionUtils.isEmpty(positionCodes)) {
      return new ArrayList<>();
    }
    return this.userPositionRepository.findByPositionCodeIn(TenantUtils.getTenantCode(), positionCodes);
  }

  @Override
  public List<UserPositionVo> listByUserNameList(List<String> userNameList) {
    if (CollectionUtils.isEmpty(userNameList)) {
      return new ArrayList<>();
    }
    List<UserPositionEntity> userPositionEntities = this.userPositionRepository.listByUserNameList(TenantUtils.getTenantCode(), userNameList);
    if (CollectionUtils.isEmpty(userPositionEntities)) {
      return new ArrayList<>();
    }
    return (List<UserPositionVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
            userPositionEntities, UserPositionEntity.class, UserPositionVo.class, LinkedHashSet.class, ArrayList.class
    );
  }
}
