package com.biz.crm.mdm.business.user.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.enums.LockStateEnum;
import com.biz.crm.mdm.business.user.sdk.enums.UserTypeEnum;
import com.biz.crm.mdm.business.user.sdk.service.UserRelWeChatVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserValidityCheckService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelWeChatVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.Date;
import java.util.List;

/**
 * 业务侧短信服务实现
 *
 * @author pengxi
 */
@Service
public class UserValidityCheckServiceImpl implements UserValidityCheckService {

  @Autowired(required = false)
  private UserVoService userVoService;
  @Autowired(required = false)
  private UserRelWeChatVoService userRelWeChatVoService;

  @Override
  public UserVo verificationManageByAccount(String account) {
    UserVo userVo = this.userVoService.findByUserName(account);
    this.verificationManage(userVo);
    return userVo;
  }

  @Override
  public UserVo verificationManageByPhone(String phone) {
    UserVo userVo = this.userVoService.findByPhone(phone);
    this.verificationManage(userVo);
    return userVo;
  }

  @Override
  public UserVo verificationManageByOpenid(String openid) {
    List<UserRelWeChatVo> byUserRelWeChatDto = this.userRelWeChatVoService.findByOpenid(openid);
    Validate.isTrue(!CollectionUtils.isEmpty(byUserRelWeChatDto), "微信未绑定任何用户！");
    Validate.isTrue(byUserRelWeChatDto.size() == 1, "微信绑定了多个用户！");
    UserRelWeChatVo one = byUserRelWeChatDto.get(0);
    List<UserRelWeChatVo> userRelWeChatVos = this.userRelWeChatVoService.findByUserName(one.getUserName());
    Validate.isTrue(userRelWeChatVos.size() == 1, "用户绑定了多个微信，请先在后台解绑！");
    UserVo userVo = this.userVoService.findByUserName(one.getUserName());
    this.verificationManage(userVo);
    return userVo;
  }

  /**
   * 查出用户信息后，检查用户有效性
   */
  private void verificationManage(UserVo userVo) {
    Validate.notNull(userVo, "当前系统不存在此用户，请先注册！");
    Validate.notBlank(userVo.getUserType(), "未知用户类型，请联系管理员！");
    Validate.isTrue(UserTypeEnum.USER.getCode().equals(userVo.getUserType()), "只有企业用户才能登录当前系统！");
    Validate.isTrue(EnableStatusEnum.ENABLE.getCode().equals(userVo.getEnableStatus()), "当前用户已禁用！");
    Validate.isTrue(LockStateEnum.UNLOCK.getCode().equals(userVo.getLockState()), "当前用户已锁定！");
    Validate.isTrue(DelFlagStatusEnum.NORMAL.getCode().equals(userVo.getDelFlag()), "此手机号已删除！");
    try {
      String fmt = "yyyy-MM-dd HH:mm:ss";
      Date now = new Date();
      if (StringUtils.isNotEmpty(userVo.getStartTime())) {
        Validate.isTrue(now.compareTo(DateUtils.parseDate(userVo.getStartTime(), fmt)) >= 0, "用户未生效");
      }
      if (StringUtils.isNotEmpty(userVo.getEndTime())) {
        Validate.isTrue(now.compareTo(DateUtils.parseDate(userVo.getEndTime(), fmt)) <= 0, "用户已失效");
      }
    } catch (ParseException e) {
      throw new IllegalArgumentException(e);
    }
    // 账号关联职位是否变更

  }

}
