package com.biz.crm.mdm.business.user.local.service.notifier;

import com.biz.crm.mdm.business.position.sdk.event.PositionEventListener;
import com.biz.crm.mdm.business.position.sdk.vo.PositionEventVo;
import com.biz.crm.mdm.business.position.sdk.vo.PositionRelationVo;
import com.biz.crm.mdm.business.user.local.entity.UserPositionEntity;
import com.biz.crm.mdm.business.user.local.service.UserPositionService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 用户监听职位变更事件
 *
 * @author pengxi
 * @date 2021/11/15
 */
@Component
public class UserPositionEventListenerImpl implements PositionEventListener {

  @Autowired(required = false)
  private UserPositionService userPositionService;

  @Override
  public void onCreate(PositionEventVo vo) {
    //暂无实现需求
  }

  @Override
  public void onCreate(List<PositionEventVo> vos) {
    //暂无实现需求
  }

  @Override
  public void onUpdate(PositionEventVo oldVo, PositionEventVo newVo) {
    //暂无实现需求
  }

  @Override
  public void onDisable(List<PositionEventVo> voList) {
    //暂无实现需求
  }

  @Override
  public void onEnable(List<PositionEventVo> voList) {
    //暂无实现需求
  }

  /**
   * 当职位发生删除事件时，根据触发事件的职位信息中的职位编码,验证职位是否存在与用户的关联关系。
   *
   * 1.存在与用户的关联关系,则抛出职位已关联用户的异常,阻断当前职位的删除操作
   * 2.不存在与用户的关联关系,则什么也不做.
   */
  @Override
  public void onDelete(List<PositionEventVo> voList) {
    if (CollectionUtils.isEmpty(voList)) {
      return;
    }
    Map<String, PositionEventVo> positionLevelMap = voList.stream().collect(Collectors.toMap(PositionEventVo::getPositionCode, t -> t));
    List<UserPositionEntity> userPositionEntities = userPositionService.findByPositionCode(positionLevelMap.keySet());
    if (CollectionUtils.isNotEmpty(userPositionEntities)) {
      List<String> positionCodes = userPositionEntities.stream().map(UserPositionEntity::getPositionCode).distinct().collect(Collectors.toList());
      throw new IllegalArgumentException("职位["+ StringUtils.join(positionCodes) +"]已经关联了用户，不能删除");
    }
  }

  @Override
  public List<PositionRelationVo> onRequestByPositionCodes(List<String> positionCodes) {
    //暂无实现需求
    return null;
  }
}
