/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.user.sdk.dto.UserPositionDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserPositionPageDto;
import com.biz.crm.mdm.business.user.sdk.service.UserPositionVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u7528\u6237\uff1aUserPositionVo\uff1a\u804c\u4f4d-\u7528\u6237\u5173\u8054\u8868"})
@RestController
@RequestMapping(value={"/v1/userPosition/userPosition"})
public class UserPositionVoController {
    private static final Logger log = LoggerFactory.getLogger(UserPositionVoController.class);
    @Autowired(required=false)
    private UserPositionVoService userPositionVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<UserPositionVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, UserPositionPageDto dto) {
        try {
            Page result = this.userPositionVoService.findByConditions(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<UserPositionVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            UserPositionVo vo = this.userPositionVoService.findDetailById(id);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\u67e5\u8be2\u804c\u4f4d-\u7528\u6237\u5173\u7cfb")
    @GetMapping(value={"/findByUserName"})
    public Result<List<UserPositionVo>> findByUserName(@RequestParam(value="tenantCode") String tenantCode, @RequestParam(value="userName") String userName) {
        try {
            List userPositionVos = this.userPositionVoService.findByUserName(tenantCode, userName);
            return Result.ok((Object)userPositionVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<?> create(@RequestBody UserPositionDto dto) {
        try {
            this.userPositionVoService.create(dto);
            return Result.ok((String)"\u521b\u5efa\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<?> update(@RequestBody UserPositionDto dto) {
        try {
            this.userPositionVoService.update(dto);
            return Result.ok((String)"\u66f4\u65b0\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u5f53\u524d\u804c\u4f4d")
    @RequestMapping(value={"updateCurrentFlagPosition"}, method={RequestMethod.PATCH, RequestMethod.POST})
    public Result<?> updateCurrentFlagPosition(@RequestBody UserPositionDto dto) {
        try {
            this.loginUserService.refreshAuthentication((Object)dto);
            return Result.ok((String)"\u66f4\u65b0\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

