/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelDingTalkDto;
import com.biz.crm.mdm.business.user.sdk.service.UserRelDingTalkVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u7528\u6237\uff1aUserRelDingTalkVo\uff1a\u7528\u6237\u4e0e\u9489\u9489\u5173\u8054\u8868"})
@RestController
@RequestMapping(value={"/v1/userRelDingTalk/UserRelDingTalkVo"})
public class UserRelDingTalkVoController {
    private static final Logger log = LoggerFactory.getLogger(UserRelDingTalkVoController.class);
    @Autowired(required=false)
    private UserRelDingTalkVoService dingTalkVoService;

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={"createBatch"})
    public Result<List<UserRelDingTalkVo>> createBatch(@RequestBody List<UserRelDingTalkDto> dto) {
        try {
            List result = this.dingTalkVoService.createBatch(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eID\u96c6\u5408\u79fb\u9664")
    @DeleteMapping(value={"/deleteByIds"})
    public Result<?> deleteByIds(@RequestParam(value="ids") List<String> ids) {
        try {
            this.dingTalkVoService.deleteByIds(ids);
            return Result.ok((String)"\u89e3\u7ed1\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\u79fb\u9664")
    @DeleteMapping(value={"/deleteByUserNames"})
    public Result<?> deleteByUserNames(@RequestParam(value="userNames") List<String> userNames) {
        try {
            this.dingTalkVoService.deleteByUserNames(userNames);
            return Result.ok((String)"\u89e3\u7ed1\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u9489\u9489ID\u96c6\u5408\u79fb\u9664")
    @DeleteMapping(value={"/deleteByDingTalkUserIds"})
    public Result<?> deleteByDingTalkUserIds(@RequestParam(value="dingTalkUserIds") List<String> dingTalkUserIds) {
        try {
            this.dingTalkVoService.deleteByDingTalkUserIds(dingTalkUserIds);
            return Result.ok((String)"\u89e3\u7ed1\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eiD\u83b7\u53d6\u7528\u6237\u548c\u9489\u9489\u5173\u7cfb\u8be6\u60c5")
    @GetMapping(value={"/findById"})
    public Result<UserRelDingTalkVo> findById(@RequestParam(value="id") String id) {
        try {
            UserRelDingTalkVo vo = this.dingTalkVoService.findById(id);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u9489\u9489ID\u83b7\u53d6\u7528\u6237\u548c\u9489\u9489\u5173\u7cfb\u5217\u8868")
    @GetMapping(value={"/findByDingTalkUserId"})
    public Result<List<UserRelDingTalkVo>> findByDingTalkUserId(@RequestParam(value="dingTalkUserId") String dingTalkUserId) {
        try {
            List result = this.dingTalkVoService.findByDingTalkUserId(dingTalkUserId);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u9489\u9489ID\u96c6\u5408\u83b7\u53d6\u7528\u6237\u548c\u9489\u9489\u5173\u7cfb\u5217\u8868")
    @GetMapping(value={"/findByDingTalkUserIds"})
    public Result<List<UserRelDingTalkVo>> findByDingTalkUserIds(@RequestParam(value="dingTalkUserIds") List<String> dingTalkUserIds) {
        try {
            List result = this.dingTalkVoService.findByDingTalkUserIds(dingTalkUserIds);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u548c\u9489\u9489\u5173\u7cfb\u5217\u8868")
    @GetMapping(value={"/findByUserName"})
    public Result<List<UserRelDingTalkVo>> findByUserName(@RequestParam(value="userName") String userName) {
        try {
            List result = this.dingTalkVoService.findByUserName(userName);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u8d26\u53f7\u96c6\u5408\u83b7\u53d6\u7528\u6237\u548c\u9489\u9489\u5173\u7cfb\u5217\u8868")
    @GetMapping(value={"/findByUserNames"})
    public Result<List<UserRelDingTalkVo>> findByUserNames(@RequestParam(value="userNames") List<String> userNames) {
        try {
            List result = this.dingTalkVoService.findByUserNames(userNames);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u8d26\u53f7\u96c6\u5408\u83b7\u53d6\u7528\u6237\u5173\u8054\u9489\u9489\u4fe1\u606f")
    @GetMapping(value={"/findMapByUserNames"})
    public Result<Map<String, Set<String>>> findMapByUserNames(@RequestParam(value="userNames") List<String> userNames) {
        try {
            Map result = this.dingTalkVoService.findMapByUserNames(userNames);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u548c\u9489\u9489\u7528\u6237ID\u4fe1\u606f")
    @GetMapping(value={"/findDingTalkUserIdByUserName"})
    public Result<Set<String>> findDingTalkUserIdByUserName(@RequestParam(value="userNames") String userName) {
        try {
            Set result = this.dingTalkVoService.findDingTalkUserIdByUserName(userName);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u8d26\u53f7\u96c6\u5408\u83b7\u53d6\u7528\u6237\u548c\u9489\u9489\u7528\u6237ID\u4fe1\u606f")
    @GetMapping(value={"/findDingTalkUserIdByUserNames"})
    public Result<Set<String>> findDingTalkUserIdByUserNames(@RequestParam(value="userNames") List<String> userNames) {
        try {
            Set result = this.dingTalkVoService.findDingTalkUserIdByUserNames(userNames);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

