/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.sdk.service.UserValidityCheckService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u7528\u6237\uff1aUserVo: \u7528\u6237\u6709\u6548\u6027\u68c0\u67e5"})
@RestController
@RequestMapping(value={"/v1/userValidityCheck/userValidityCheck"})
public class UserValidityCheckController {
    private static final Logger log = LoggerFactory.getLogger(UserValidityCheckController.class);
    @Autowired(required=false)
    private UserValidityCheckService userValidityCheckService;

    @ApiOperation(value="\u6839\u636e\u8d26\u53f7\u6821\u9a8c\u3010\u7ba1\u7406\u7aef\u3011\u7528\u6237\u6709\u6548\u6027")
    @GetMapping(value={"/findByAccount"})
    public Result<UserVo> findByAccount(@RequestParam(value="account") String account) {
        try {
            UserVo result = this.userValidityCheckService.verificationManageByAccount(account);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u6821\u9a8c\u3010\u7ba1\u7406\u7aef\u3011\u7528\u6237\u6709\u6548\u6027")
    @GetMapping(value={"/findByPhone"})
    public Result<UserVo> findByPhone(@RequestParam(value="phone") String phone) {
        try {
            UserVo result = this.userValidityCheckService.verificationManageByPhone(phone);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eopenid\u6821\u9a8c\u3010\u7ba1\u7406\u7aef\u3011\u7528\u6237\u6709\u6548\u6027")
    @GetMapping(value={"/findByOpenid"})
    public Result<UserVo> findByOpenid(@RequestParam(value="openid") String openid) {
        try {
            UserVo result = this.userValidityCheckService.verificationManageByOpenid(openid);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

