/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.local.service.UserService;
import com.biz.crm.mdm.business.user.sdk.dto.UserChangePasswordDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserFeignDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserForceChangePasswordDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserPageDto;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f01\u4e1a\u7528\u6237\uff1aUserVo: \u4f01\u4e1a\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/user/user"})
public class UserVoController {
    private static final Logger log = LoggerFactory.getLogger(UserVoController.class);
    @Autowired(required=false)
    private UserService userService;
    @Autowired(required=false)
    private UserVoService userVoService;
    @Autowired(required=false)
    private UserFeignVoService userFeignVoService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<UserVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, UserPageDto dto) {
        try {
            Page result = this.userVoService.findByConditions(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u62c9\u53d6 MDG \u5458\u5de5\u6570\u636e")
    @PostMapping(value={"/pullUserList"})
    public Result<?> pullUserList(@RequestBody MasterDataMdgBaseDto dto) {
        try {
            this.userService.pullUserList(dto);
            return Result.ok((String)"\u6279\u91cf\u62c9\u53d6 MDG \u5458\u5de5\u6570\u636e\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<UserVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            UserVo vo = this.userVoService.findDetailById(id);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/findByUserName"})
    public Result<UserVo> findByUserName(@RequestParam(value="userName") String userName) {
        try {
            log.info("\u6839\u636e\u7528\u6237\u8d26\u53f7\u67e5\u8be2\u8be6\u60c5:{}", (Object)userName);
            UserVo vo = this.userVoService.findByUserName(userName);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<?> create(@RequestBody UserDto dto) {
        try {
            this.userVoService.create(dto);
            return Result.ok((String)"\u521b\u5efa\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<?> update(@RequestBody UserDto dto) {
        try {
            this.userVoService.update(dto);
            return Result.ok((String)"\u66f4\u65b0\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.userVoService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.userVoService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.userVoService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7528\u6237\u89e3\u9501")
    @DeleteMapping(value={"/deleteUserLockByIds"})
    public Result<?> deleteUserLockByIds(@RequestParam(value="ids") List<String> ids) {
        try {
            this.userVoService.deleteUserLockByIds(ids);
            return Result.ok((String)"\u89e3\u9501\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u5bc6\u7801")
    @PatchMapping(value={"/updatePasswordByIds"})
    public Result<?> updatePasswordByIds(@RequestBody UserForceChangePasswordDto dto) {
        try {
            this.userVoService.updatePasswordByIds(dto);
            return Result.ok((String)"\u4fee\u6539\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @PatchMapping(value={"/updatePasswordByUserName"})
    public Result<?> updatePasswordByUserName(@RequestBody UserChangePasswordDto dto) {
        try {
            this.userVoService.updatePasswordByUserName(dto);
            return Result.ok((String)"\u4fee\u6539\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @PostMapping(value={"/updatePasswordByUserName/updateTurnPatch"})
    public Result<?> updateTurnPatch(@RequestBody UserChangePasswordDto dto) {
        return this.updatePasswordByUserName(dto);
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u548c\u804c\u4f4d\u7ea7\u522b\u96c6\u5408\u548c\u7528\u6237\u7c7b\u578b\u67e5\u8be2\u7f16\u7801\u96c6\u5408")
    @GetMapping(value={"/findUserNamesByCodesAndUserType"})
    public Result<Set<String>> findUserNamesByCodesAndUserType(@RequestParam(value="orgCodes", required=false) List<String> orgCodes, @RequestParam(value="positionLevelCodes", required=false) List<String> positionLevelCodes, @RequestParam(value="userType") String userType) {
        try {
            Set result = this.userVoService.findUserNamesByCodesAndUserType(orgCodes, positionLevelCodes, userType);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u7528\u6237\u8d26\u53f7\u67e5\u8be2\u96c6\u5408(\u5305\u542b\u804c\u4f4d\u548c\u7ec4\u7ec7)")
    @GetMapping(value={"/findByUserNames"})
    public Result<List<UserVo>> findByUserNames(@RequestParam(value="userNames") List<String> userNames) {
        try {
            return Result.ok((Object)this.userFeignVoService.findByUserNames(userNames));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u5927\u91cf\u7528\u6237\u8d26\u53f7\u67e5\u8be2\u96c6\u5408(\u5305\u542b\u804c\u4f4d\u548c\u7ec4\u7ec7)")
    @PostMapping(value={"/findByLotUserNames"})
    public Result<List<UserVo>> findByLotUserNames(@RequestBody List<String> userNames) {
        try {
            return Result.ok((Object)this.userFeignVoService.findByLotUserNames(userNames));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u7528\u6237\u8d26\u53f7\u67e5\u8be2\u96c6\u5408(\u5305\u542b\u804c\u4f4d\u548c\u7ec4\u7ec7)")
    @GetMapping(value={"/findDetailsByPhone"})
    public Result<UserVo> findDetailsByPhone(@RequestParam(value="phone") String phone) {
        try {
            return Result.ok((Object)this.userVoService.findDetailsByPhone(phone));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u7167\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u8d26\u53f7\u96c6\u5408")
    @PostMapping(value={"/findUserNamesByUserDto"})
    public Result<Set<String>> findUserNamesByUserDto(@RequestBody UserFeignDto dto) {
        try {
            return Result.ok((Object)this.userFeignVoService.findUserNamesByUserDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u68c0\u67e5\u7528\u6237\u8d26\u53f7\u4e0e\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u6216\u7ec4\u7ec7\u7c7b\u578b\uff08\u5c42\u7ea7\uff09\u96c6\u5408\u662f\u5426\u5173\u8054")
    @GetMapping(value={"/findRelationByUserNameAndOrgCodesOrOrgTypes"})
    public Result<UserVo> findRelationByUserNameAndOrgCodesOrOrgTypes(@RequestParam(value="userName", required=true) String userName, @RequestParam(value="orgCodes", required=false) List<String> orgCodes, @RequestParam(value="orgTypes", required=false) List<String> orgTypes) {
        try {
            UserVo userVo = this.userVoService.findRelationByUserNameAndOrgCodesOrOrgTypes(userName, orgCodes, orgTypes);
            return Result.ok((Object)userVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u591a\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u8d26\u53f7\u4fe1\u606f")
    @GetMapping(value={"/findUserNamesByUserConditionDto"})
    public Result<Set<String>> findUserNamesByUserConditionDto(UserConditionDto dto) {
        try {
            return Result.ok((Object)this.userVoService.findUserNamesByUserConditionDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\u96c6\u5408\u67e5\u8be2\u804c\u4f4d\u7f16\u7801\u96c6\u5408")
    @GetMapping(value={"/findPositionCodesByUserNames"})
    public Result<Set<String>> findPositionCodesByUserNames(@RequestParam(value="userNames") List<String> userNames) {
        try {
            return Result.ok((Object)this.userVoService.findPositionCodesByUserNames(userNames));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\u67e5\u8be2\u8d26\u53f7\u4fe1\u606f")
    @GetMapping(value={"/findUserNamesByUserNames"})
    public Result<Set<String>> findUserNamesByUserNames(@RequestParam(value="userNames") List<String> userNames) {
        try {
            return Result.ok((Object)this.userVoService.findUserNamesByUserNames(userNames));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\u67e5\u8be2\u7528\u6237\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/findUserAllMsgByUserName"})
    public Result<UserVo> findUserAllMsgByUserName(@RequestParam(value="userName") String userName) {
        try {
            return Result.ok((Object)this.userVoService.findUserAllMsgByUserName(userName));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

