/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.event;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.user.sdk.event.UserEventListener;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserLogEventListener
implements UserEventListener {
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onCreate(UserVo vo) {
        String onlyKey = vo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(null);
        crmBusinessLogDto.setNewObject((Object)vo);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onUpdate(UserVo oldVo, UserVo newVo) {
        String onlyKey = newVo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)oldVo);
        crmBusinessLogDto.setNewObject((Object)newVo);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onEnable(List<UserVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(userVo -> {
            String onlyKey = userVo.getId();
            UserVo oldObj = new UserVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(userVo.getEnableStatus());
            UserVo newObj = new UserVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            this.onUpdate(oldObj, newObj);
        });
    }

    public void onDisable(List<UserVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(userVo -> {
            String onlyKey = userVo.getId();
            UserVo oldObj = new UserVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(userVo.getEnableStatus());
            UserVo newObj = new UserVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            this.onUpdate(oldObj, newObj);
        });
    }

    public void onDelete(List<UserVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(userVo -> {
            String onlyKey = userVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(userVo);
            crmBusinessLogDto.setNewObject(null);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }
}

