/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mdm.business.user.local.entity.UserRelWeChatEntity;
import com.biz.crm.mdm.business.user.local.mapper.UserRelWeChatMapper;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelWeChatDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelWeChatPageDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserWeChatBindDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelWeChatVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class UserRelWeChatRepository
extends ServiceImpl<UserRelWeChatMapper, UserRelWeChatEntity> {
    public Page<UserRelWeChatVo> findByConditions(Pageable pageable, @Param(value="dto") UserRelWeChatPageDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto = Optional.ofNullable(dto).orElse(new UserRelWeChatPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((UserRelWeChatMapper)this.baseMapper).findByConditions((Page<UserRelWeChatPageDto>)page, dto);
    }

    public UserRelWeChatEntity findById(String id) {
        return (UserRelWeChatEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public void deleteByUserNames(@Param(value="tenantCode") String tenantCode, @Param(value="userNames") List<String> userNames) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(UserRelWeChatEntity::getUserName, userNames)).remove();
    }

    public List<UserRelWeChatEntity> findByUserRelWeChatDto(@Param(value="tenantCode") String tenantCode, @Param(value="dto") UserRelWeChatDto dto) {
        if (StringUtils.isBlank((CharSequence)(dto = Optional.ofNullable(dto).orElse(new UserRelWeChatDto())).getUserName())) {
            return new ArrayList<UserRelWeChatEntity>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(UserRelWeChatEntity::getUserName, (Object)dto.getUserName())).eq(StringUtils.isNotBlank((CharSequence)dto.getOriginModule()), UserRelWeChatEntity::getOriginModule, (Object)dto.getOriginModule())).eq(Objects.nonNull(dto.getLoginStatus()), UserRelWeChatEntity::getLoginStatus, (Object)dto.getLoginStatus())).like(StringUtils.isNotBlank((CharSequence)dto.getNickName()), UserRelWeChatEntity::getNickName, (Object)dto.getNickName())).list();
    }

    public List<UserRelWeChatEntity> findByUserWeChatBindDto(UserWeChatBindDto dto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)dto.getTenantCode())).eq(UserRelWeChatEntity::getOriginModule, (Object)dto.getOriginModule())).eq(StringUtils.isNotBlank((CharSequence)dto.getUserName()), UserRelWeChatEntity::getUserName, (Object)dto.getUserName())).eq(StringUtils.isNotBlank((CharSequence)dto.getOpenId()), UserRelWeChatEntity::getOpenId, (Object)dto.getOpenId())).list();
    }

    public List<UserRelWeChatEntity> findByOpenid(String tenantCode, String openid) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(UserRelWeChatEntity::getOpenId, (Object)openid)).list();
    }

    public List<UserRelWeChatEntity> findByUserName(String tenantCode, String userName) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(UserRelWeChatEntity::getUserName, (Object)userName)).list();
    }

    public void updateByIdAndTenantCode(UserRelWeChatEntity entity, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{entity.getId()});
        ((UserRelWeChatMapper)this.baseMapper).update((Object)entity, (Wrapper)lambdaUpdateWrapper);
    }

    public void removeByIdsAndTenantCode(List<String> ids, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).remove();
    }
}

