/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.user.local.entity.UserEntity;
import com.biz.crm.mdm.business.user.local.mapper.UserMapper;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserPageDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class UserRepository
extends ServiceImpl<UserMapper, UserEntity> {
    public Page<UserVo> findByConditions(Pageable pageable, @Param(value="dto") UserPageDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto = Optional.ofNullable(dto).orElse(new UserPageDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<UserVo> voPage = ((UserMapper)this.baseMapper).findByConditions((Page<UserPageDto>)page, dto);
        if (CollectionUtils.isNotEmpty((Collection)voPage.getRecords())) {
            voPage.getRecords().forEach(s -> {
                if (CollectionUtils.isNotEmpty((Collection)s.getPositionList())) {
                    Optional<UserPositionVo> first = s.getPositionList().stream().filter(m -> BooleanUtils.isTrue((Boolean)m.getPrimaryFlag())).findFirst();
                    first.ifPresent(n -> {
                        s.setMajorPositionCode(n.getPositionCode());
                        s.setMajorPositionName(n.getUserName());
                    });
                }
            });
        }
        return voPage;
    }

    public UserEntity findByUserCode(@Param(value="tenantCode") String tenantCode, @Param(value="userCode") String userCode) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq(UserEntity::getUserCode, (Object)userCode);
        return (UserEntity)((Object)((UserMapper)this.baseMapper).selectOne((Wrapper)wrapper));
    }

    public UserEntity findByUserName(@Param(value="tenantCode") String tenantCode, @Param(value="userName") String userName) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq(UserEntity::getUserName, (Object)userName);
        return (UserEntity)((Object)((UserMapper)this.baseMapper).selectOne((Wrapper)wrapper));
    }

    public UserEntity findByUserNameCoverDel(@Param(value="tenantCode") String tenantCode, @Param(value="userName") String userName) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UserEntity::getUserName, (Object)userName);
        return (UserEntity)((Object)((UserMapper)this.baseMapper).selectOne((Wrapper)wrapper));
    }

    public List<UserEntity> findByUserNames(@Param(value="tenantCode") String tenantCode, @Param(value="userNames") Collection<String> userNames) {
        if (CollectionUtil.isEmpty(userNames) || StringUtils.isBlank((CharSequence)tenantCode)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.in(UserEntity::getUserName, userNames);
        return ((UserMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public List<UserEntity> findByUserPhone(@Param(value="tenantCode") String tenantCode, @Param(value="userPhone") String userPhone) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UserEntity::getUserPhone, (Object)userPhone);
        return ((UserMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public List<UserEntity> findByEmail(@Param(value="tenantCode") String tenantCode, @Param(value="email") String email) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq(UserEntity::getEmail, (Object)email);
        return ((UserMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public List<UserEntity> findByIdentityCardNumber(@Param(value="tenantCode") String tenantCode, @Param(value="identityCardNumber") String identityCardNumber) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq(UserEntity::getIdentityCardNumber, (Object)identityCardNumber);
        return ((UserMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public List<UserEntity> findByIds(@Param(value="ids") List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updatePasswordByIds(List<String> ids, String password) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).set(UserEntity::getUserPassword, (Object)password)).set(UserEntity::getForceChangePassword, (Object)Boolean.FALSE)).update();
    }

    public List<UserEntity> findByUserNamesAndUserType(String tenantCode, Set<String> userNames, String userType) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UserEntity::getUserType, (Object)userType)).in(UserEntity::getUserName, userNames)).list();
        return list;
    }

    public Set<String> findUserNamesByUserConditionDto(UserConditionDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((UserMapper)this.baseMapper).findUserNamesByUserConditionDto(dto);
    }

    public void updateByIdAndTenantCode(UserEntity entity, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{entity.getId()});
        ((UserMapper)this.baseMapper).update((Object)entity, (Wrapper)lambdaUpdateWrapper);
    }

    public UserEntity findByIdAndTenantCode(String id, String tenantCode) {
        return (UserEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public List<UserEntity> findByUserCodes(String tenantCode, Set<String> userCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UserEntity::getUserCode, userCodes)).list();
    }

    public List<UserEntity> findByUserNames(List<String> userNameList) {
        if (CollectionUtils.isEmpty(userNameList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UserEntity::getUserName, userNameList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public UserVo findUserAllMsgByUserName(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return null;
        }
        return ((UserMapper)this.baseMapper).findUserAllMsgByUserName(userName, TenantUtils.getTenantCode());
    }

    public List<UserEntity> listByUserPhone(List<String> userPhoneList) {
        if (CollectionUtils.isEmpty(userPhoneList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UserEntity::getUserPhone, userPhoneList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<UserVo> findUserByOrgCodes(List<String> orgCodeList) {
        return ((UserMapper)this.baseMapper).findUserByOrgCodes(orgCodeList);
    }
}

