/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.mdm.business.user.local.entity.UserRelDingTalkEntity;
import com.biz.crm.mdm.business.user.local.repository.UserRelDingTalkRepository;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelDingTalkDto;
import com.biz.crm.mdm.business.user.sdk.service.UserRelDingTalkVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class UserRelDingTalkVoServiceImpl
implements UserRelDingTalkVoService {
    private static final Logger log = LoggerFactory.getLogger(UserRelDingTalkVoServiceImpl.class);
    @Autowired(required=false)
    private UserRelDingTalkRepository userRelDingTalkRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private UserVoService userVoService;

    @Transactional(rollbackFor={Exception.class})
    public List<UserRelDingTalkVo> createBatch(List<UserRelDingTalkDto> dtoList) {
        this.createValidation(dtoList);
        List<String> userNameList = dtoList.stream().map(UserRelDingTalkDto::getUserName).distinct().collect(Collectors.toList());
        this.userRelDingTalkRepository.deleteByUserNames(userNameList);
        Collection entityList = this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, UserRelDingTalkDto.class, UserRelDingTalkEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.userRelDingTalkRepository.saveBatch(entityList);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entityList, UserRelDingTalkEntity.class, UserRelDingTalkVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidation(List<UserRelDingTalkDto> dtoList) {
        Assert.notEmpty(dtoList, (String)"\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        String tenantCode = TenantUtils.getTenantCode();
        dtoList.forEach(dto -> {
            Assert.hasLength((String)dto.getUserName(), (String)"\u8d26\u53f7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.hasLength((String)dto.getDingTalkUserId(), (String)"\u9489\u9489ID\u4e0d\u80fd\u4e3a\u7a7a!");
            dto.setTenantCode(tenantCode);
        });
        List userNameList = dtoList.stream().map(UserRelDingTalkDto::getUserName).distinct().collect(Collectors.toList());
        Set userNameSet = this.userVoService.findUserNamesByUserNames(userNameList);
        Assert.notEmpty((Collection)userNameSet, (String)"\u8d26\u53f7\u4e0d\u5b58\u5728!");
        dtoList.forEach(dto -> Assert.isTrue((boolean)userNameSet.contains(dto.getUserName()), (String)("\u8d26\u53f7[" + dto.getUserName() + "]\u4e0d\u5b58\u5728!")));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<String> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        this.userRelDingTalkRepository.deleteByIds(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByUserNames(List<String> userNameList) {
        if (CollectionUtil.isEmpty(userNameList)) {
            return;
        }
        this.userRelDingTalkRepository.deleteByUserNames(userNameList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByDingTalkUserIds(List<String> dingTalkUserIds) {
        if (CollectionUtil.isEmpty(dingTalkUserIds)) {
            return;
        }
        this.userRelDingTalkRepository.deleteByDingTalkUserIds(dingTalkUserIds);
    }

    public UserRelDingTalkVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        UserRelDingTalkEntity entity = this.userRelDingTalkRepository.findById(id);
        if (entity == null) {
            return null;
        }
        return (UserRelDingTalkVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, UserRelDingTalkVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<UserRelDingTalkVo> findByDingTalkUserId(String dingTalkUserId) {
        if (StringUtils.isBlank((CharSequence)dingTalkUserId)) {
            return null;
        }
        List<UserRelDingTalkEntity> entityList = this.userRelDingTalkRepository.findByDingTalkUserId(dingTalkUserId);
        if (CollectionUtil.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entityList, UserRelDingTalkEntity.class, UserRelDingTalkVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<UserRelDingTalkVo> findByDingTalkUserIds(List<String> dingTalkUserIds) {
        if (CollectionUtil.isEmpty(dingTalkUserIds)) {
            return null;
        }
        List<UserRelDingTalkEntity> entityList = this.userRelDingTalkRepository.findByDingTalkUserIds(dingTalkUserIds);
        if (CollectionUtil.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entityList, UserRelDingTalkEntity.class, UserRelDingTalkVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<UserRelDingTalkVo> findByUserName(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return Collections.emptyList();
        }
        List<UserRelDingTalkEntity> entityList = this.userRelDingTalkRepository.findByUserName(userName);
        if (CollectionUtil.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entityList, UserRelDingTalkEntity.class, UserRelDingTalkVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<UserRelDingTalkVo> findByUserNames(List<String> userNameList) {
        if (CollectionUtil.isEmpty(userNameList)) {
            return Collections.emptyList();
        }
        List<UserRelDingTalkEntity> entityList = this.userRelDingTalkRepository.findByUserNames(userNameList);
        if (CollectionUtil.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entityList, UserRelDingTalkEntity.class, UserRelDingTalkVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Map<String, Set<String>> findMapByUserNames(List<String> userNameList) {
        if (CollectionUtil.isEmpty(userNameList)) {
            return Collections.emptyMap();
        }
        List<UserRelDingTalkEntity> entityList = this.userRelDingTalkRepository.findByUserNames(userNameList);
        if (CollectionUtil.isEmpty(entityList)) {
            return Collections.emptyMap();
        }
        return entityList.stream().filter(k -> StringUtils.isBlank((CharSequence)k.getUserName())).filter(k -> StringUtils.isBlank((CharSequence)k.getDingTalkUserId())).collect(Collectors.groupingBy(UserRelDingTalkEntity::getUserName, Collectors.mapping(UserRelDingTalkEntity::getDingTalkUserId, Collectors.toSet())));
    }

    public Set<String> findDingTalkUserIdByUserName(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return Collections.emptySet();
        }
        List<UserRelDingTalkEntity> entityList = this.userRelDingTalkRepository.findByUserName(userName);
        if (CollectionUtil.isEmpty(entityList)) {
            return Collections.emptySet();
        }
        return entityList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getDingTalkUserId())).map(UserRelDingTalkEntity::getDingTalkUserId).collect(Collectors.toSet());
    }

    public Set<String> findDingTalkUserIdByUserNames(List<String> userNameList) {
        if (CollectionUtil.isEmpty(userNameList)) {
            return Collections.emptySet();
        }
        List<UserRelDingTalkEntity> entityList = this.userRelDingTalkRepository.findByUserNames(userNameList);
        if (CollectionUtil.isEmpty(entityList)) {
            return Collections.emptySet();
        }
        return entityList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getDingTalkUserId())).map(UserRelDingTalkEntity::getDingTalkUserId).collect(Collectors.toSet());
    }
}

