/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.position.sdk.enums.PositionSourceEnum;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.local.entity.UserEntity;
import com.biz.crm.mdm.business.user.local.repository.UserRepository;
import com.biz.crm.mdm.business.user.local.service.UserPositionService;
import com.biz.crm.mdm.business.user.local.service.UserService;
import com.biz.crm.mdm.business.user.sdk.dto.UserDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserPositionDto;
import com.biz.crm.mdm.business.user.sdk.enums.UserSourceEnum;
import com.biz.crm.mdm.business.user.sdk.enums.UserTypeEnum;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.enums.EffStatusEnum;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgUserVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired(required=false)
    private UserRepository userRepository;
    @Autowired(required=false)
    private UserVoService userVoService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private PositionVoService positionVoService;
    @Autowired(required=false)
    private UserPositionService userPositionService;
    @Autowired(required=false)
    private MasterDataMdgService masterDataMdgService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pullUserList(MasterDataMdgBaseDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new MasterDataMdgBaseDto();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageNum())) {
            dto.setPageNum("1");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageSize())) {
            dto.setPageSize("400");
        }
        boolean lock = true;
        String lockKey = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        if (!StringUtils.isEmpty((CharSequence)dto.getUdate())) {
            lockKey = dto.getUdate();
        }
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            List masterDataMdgUserVos = this.masterDataMdgService.pullUserList(dto);
            if (CollectionUtils.isEmpty((Collection)masterDataMdgUserVos)) {
                return;
            }
            Set userNameSet = masterDataMdgUserVos.stream().map(MasterDataMdgUserVo::getEMPLID).collect(Collectors.toSet());
            List<UserEntity> userEntities = this.userRepository.findByUserNames(new ArrayList<String>(userNameSet));
            Map userMap = userEntities.stream().collect(Collectors.toMap(UserEntity::getUserName, Function.identity()));
            Set phoneSet = masterDataMdgUserVos.stream().map(MasterDataMdgUserVo::getMNCELLPHONE).collect(Collectors.toSet());
            List<UserEntity> userPhoneList = this.userRepository.listByUserPhone(new ArrayList<String>(phoneSet));
            Map<String, String> phoneMap = userPhoneList.stream().collect(Collectors.toMap(UserEntity::getUserPhone, UserEntity::getUserName));
            ArrayList<MasterDataMdgUserVo> successList = new ArrayList<MasterDataMdgUserVo>();
            List<UserDto> pullList = this.userValidate(masterDataMdgUserVos, successList);
            List<UserPositionDto> userPositionList = this.positionValidate(successList);
            Map userPositionMap = userPositionList.stream().collect(Collectors.toMap(UserPositionDto::getUserName, Function.identity()));
            ArrayList saveList = new ArrayList();
            ArrayList updateList = new ArrayList();
            pullList.forEach(pull -> {
                if (!userPositionMap.containsKey(pull.getUserName())) {
                    return;
                }
                pull.setPositionList(Collections.singletonList(userPositionMap.get(pull.getUserName())));
                pull.setUserType(UserTypeEnum.USER.getCode());
                if (userMap.containsKey(pull.getUserName())) {
                    UserEntity userEntity = (UserEntity)((Object)((Object)userMap.get(pull.getUserName())));
                    pull.setId(userEntity.getId());
                    pull.setUserPassword(userEntity.getUserPassword());
                    pull.setMd5Flag(BooleanEnum.FALSE.getCapital());
                    pull.setUserCode(userEntity.getUserCode());
                    updateList.add(pull);
                } else {
                    if (phoneMap.containsKey(pull.getUserPhone())) {
                        return;
                    }
                    pull.setMd5Flag(BooleanEnum.FALSE.getCapital());
                    pull.setUserPassword("e19481fb576bade223bc94e280cb6323");
                    saveList.add(pull);
                }
            });
            if (!CollectionUtils.isEmpty(saveList)) {
                log.info(">>>>>>>>>>-----------------\u672c\u6b21\u5171\u62c9\u53d6\u5230\u65b0\u589e\u6570\u636e\uff1a" + saveList.size() + "\u6761--------------------<<<<<<<<<<<");
                this.userVoService.createMdgBatch(saveList);
            }
            if (!CollectionUtils.isEmpty(updateList)) {
                log.info(">>>>>>>>>>-----------------\u672c\u6b21\u5171\u62c9\u53d6\u5230\u66f4\u65b0\u6570\u636e\uff1a" + updateList.size() + "\u6761--------------------<<<<<<<<<<<");
                this.userVoService.updateMdgBatch(updateList);
            }
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    private List<UserPositionDto> positionValidate(List<MasterDataMdgUserVo> masterDataMdgUserVos) {
        Set mdgPositionCodeSet = masterDataMdgUserVos.stream().map(MasterDataMdgUserVo::getPOSITIONNBR).filter(Objects::nonNull).collect(Collectors.toSet());
        Set userNameSet = masterDataMdgUserVos.stream().map(MasterDataMdgUserVo::getEMPLID).collect(Collectors.toSet());
        Set mdgParentCodeSet = masterDataMdgUserVos.stream().map(MasterDataMdgUserVo::getMNJOBEMPLID).collect(Collectors.toSet());
        List mdgPositionVoList = this.positionVoService.findByMdgPositionCodeList(new ArrayList(mdgPositionCodeSet));
        Map<String, List<PositionVo>> mdgPositionVoMap = mdgPositionVoList.stream().collect(Collectors.groupingBy(PositionVo::getMdgPositionCode));
        List<UserPositionVo> userPositionVoList = this.userPositionService.listByUserNameList(new ArrayList<String>(userNameSet));
        List<UserPositionVo> parentUserPositionVoList = this.userPositionService.listByUserNameList(new ArrayList<String>(mdgParentCodeSet));
        List parentCodeList = parentUserPositionVoList.stream().map(UserPositionVo::getPositionCode).collect(Collectors.toList());
        List parentList = this.positionVoService.findByIdsOrCodes(null, parentCodeList);
        Map parentMap = parentList.stream().collect(Collectors.toMap(PositionVo::getPositionCode, Function.identity()));
        Map<String, List<UserPositionVo>> parentUserPositionMap = parentUserPositionVoList.stream().collect(Collectors.groupingBy(UserPositionVo::getUserName));
        Map<String, List<UserPositionVo>> userPositionMap = userPositionVoList.stream().collect(Collectors.groupingBy(UserPositionVo::getUserName));
        HashMap dupPositionMap = new HashMap();
        ArrayList<UserPositionDto> positionList = new ArrayList<UserPositionDto>();
        masterDataMdgUserVos.forEach(masterDataMdgUserVo -> {
            List mdgUserPositionList;
            UserPositionDto userPositionDto = new UserPositionDto();
            userPositionDto.setUserName(masterDataMdgUserVo.getEMPLID());
            userPositionDto.setMdgPositionCode(masterDataMdgUserVo.getPOSITIONNBR());
            userPositionDto.setPositionSource(PositionSourceEnum.MDG.getCode());
            userPositionDto.setParentUserName(masterDataMdgUserVo.getMNJOBEMPLID());
            userPositionDto.setOrgCode(masterDataMdgUserVo.getDEPTID());
            AtomicBoolean existFlag = new AtomicBoolean(false);
            if (userPositionMap.containsKey(masterDataMdgUserVo.getEMPLID()) && !CollectionUtils.isEmpty(mdgUserPositionList = ((List)userPositionMap.get(masterDataMdgUserVo.getEMPLID())).stream().filter(userPositionVo -> PositionSourceEnum.MDG.getCode().equals(userPositionVo.getPositionSource()) && userPositionDto.getMdgPositionCode().equals(userPositionVo.getMdgPositionCode())).collect(Collectors.toList()))) {
                userPositionDto.setPositionCode(((UserPositionVo)mdgUserPositionList.get(0)).getPositionCode());
                userPositionDto.setPrimaryFlag(((UserPositionVo)mdgUserPositionList.get(0)).getPrimaryFlag());
                userPositionDto.setOperationType(Boolean.valueOf(false));
                existFlag.set(true);
            }
            if (!existFlag.get()) {
                if (userPositionMap.containsKey(masterDataMdgUserVo.getEMPLID())) {
                    userPositionDto.setPrimaryFlag(Boolean.valueOf(false));
                } else {
                    userPositionDto.setPrimaryFlag(Boolean.valueOf(true));
                }
                userPositionDto.setOperationType(Boolean.valueOf(true));
                if (dupPositionMap.containsKey(userPositionDto.getMdgPositionCode())) {
                    UserPositionDto dupPosition = ((List)dupPositionMap.get(userPositionDto.getMdgPositionCode())).stream().max(Comparator.comparingInt(UserPositionDto::getSuffixSequence)).get();
                    userPositionDto.setPositionCode((String)this.generateCodeService.generateCode("ZW", 1).get(0));
                    userPositionDto.setPositionName(dupPosition.getPositionName().split("_")[0] + "_" + (dupPosition.getSuffixSequence() + 1));
                    userPositionDto.setSuffixSequence(Integer.valueOf(dupPosition.getSuffixSequence() + 1));
                    List userPositionDtoList = (List)dupPositionMap.get(userPositionDto.getMdgPositionCode());
                    userPositionDtoList.add(userPositionDto);
                    dupPositionMap.put(userPositionDto.getMdgPositionCode(), userPositionDtoList);
                } else {
                    ArrayList<UserPositionDto> userPositionDtoList = new ArrayList<UserPositionDto>();
                    PositionVo positionVo = ((List)mdgPositionVoMap.get(userPositionDto.getMdgPositionCode())).stream().filter(mdgPositionVo -> mdgPositionVo.getSuffixSequence() != null).max(Comparator.comparingInt(PositionVo::getSuffixSequence)).get();
                    userPositionDto.setPositionCode((String)this.generateCodeService.generateCode("ZW", 1).get(0));
                    userPositionDto.setPositionName(positionVo.getPositionName().split("_")[0] + "_" + (positionVo.getSuffixSequence() + 1));
                    userPositionDto.setSuffixSequence(Integer.valueOf(positionVo.getSuffixSequence() + 1));
                    userPositionDtoList.add(userPositionDto);
                    dupPositionMap.put(userPositionDto.getMdgPositionCode(), userPositionDtoList);
                }
            }
            positionList.add(userPositionDto);
        });
        Map userPositionDtoMap = positionList.stream().collect(Collectors.toMap(UserPositionDto::getUserName, Function.identity()));
        positionList.forEach(position -> {
            if (StringUtils.isEmpty((CharSequence)position.getParentUserName())) {
                return;
            }
            if (userPositionDtoMap.containsKey(position.getParentUserName())) {
                position.setParentCode(((UserPositionDto)userPositionDtoMap.get(position.getParentUserName())).getPositionCode());
            } else if (parentUserPositionMap.containsKey(position.getParentUserName())) {
                ((List)parentUserPositionMap.get(position.getParentUserName())).forEach(parentUserPositionVo -> {
                    if (PositionSourceEnum.MDG.getCode().equals(parentUserPositionVo.getPositionSource()) && parentMap.containsKey(parentUserPositionVo.getPositionCode())) {
                        position.setMdgParentCode(((PositionVo)parentMap.get(parentUserPositionVo.getPositionCode())).getMdgPositionCode());
                        position.setParentCode(((PositionVo)parentMap.get(parentUserPositionVo.getPositionCode())).getPositionCode());
                    }
                });
            }
        });
        return positionList;
    }

    private void buildPosition(List<UserDto> pullList) {
        ArrayList userPositionDtoList = new ArrayList();
        pullList.forEach(pull -> userPositionDtoList.add(pull.getPositionList().get(0)));
        Set userNameSet = userPositionDtoList.stream().map(UserPositionDto::getUserName).collect(Collectors.toSet());
        List<UserPositionVo> userPositionVoList = this.userPositionService.listByUserNameList(new ArrayList<String>(userNameSet));
        Map<String, String> userMdgPosMap = userPositionVoList.stream().collect(Collectors.toMap(UserPositionVo::getUserName, UserPositionVo::getMdgPositionCode));
        Set mdgPositionCodeSet = userPositionDtoList.stream().map(UserPositionDto::getMdgPositionCode).collect(Collectors.toSet());
        Set mdgParentCodeSet = Optional.ofNullable(userPositionDtoList.stream().map(UserPositionDto::getMdgParentCode).filter(Objects::nonNull).collect(Collectors.toSet())).orElse(new HashSet());
        mdgPositionCodeSet.addAll(mdgParentCodeSet);
        List positionVoList = this.positionVoService.findByMdgPositionCodeList(new ArrayList(mdgPositionCodeSet));
        Map<String, List<PositionVo>> mdgPositionMap = positionVoList.stream().collect(Collectors.groupingBy(PositionVo::getMdgPositionCode));
        ArrayList savePositionList = new ArrayList();
        pullList.forEach(pull -> pull.getPositionList().forEach(userPositionDto -> {
            if (!userMdgPosMap.containsKey(userPositionDto.getUserName()) || !((String)userMdgPosMap.get(userPositionDto.getUserName())).equals(userPositionDto.getPositionCode())) {
                userPositionDto.setOperationType(Boolean.valueOf(true));
            }
        }));
    }

    private List<UserDto> userNewValidate(List<MasterDataMdgUserVo> masterDataMdgUserVos) {
        Map masterDataMdgUserVoMap = masterDataMdgUserVos.stream().collect(Collectors.toMap(MasterDataMdgUserVo::getEMPLID, Function.identity(), (oldVo, newVo) -> newVo));
        Set mdgPositionCodeSet = masterDataMdgUserVos.stream().map(MasterDataMdgUserVo::getPOSITIONNBR).filter(Objects::nonNull).collect(Collectors.toSet());
        Set userNameSet = masterDataMdgUserVos.stream().map(MasterDataMdgUserVo::getEMPLID).collect(Collectors.toSet());
        Set mdgParentCodeSet = masterDataMdgUserVos.stream().map(MasterDataMdgUserVo::getMNJOBEMPLID).collect(Collectors.toSet());
        HashMap codeMap = new HashMap(8);
        List mdgPositionVoList = this.positionVoService.findByMdgPositionCodeList(new ArrayList(mdgPositionCodeSet));
        Map mdgPositionVoMap = mdgPositionVoList.stream().collect(Collectors.toMap(PositionVo::getMdgPositionCode, Function.identity(), (oldVo, newVo) -> newVo));
        Set orgCodeSet = masterDataMdgUserVos.stream().map(MasterDataMdgUserVo::getDEPTID).filter(Objects::nonNull).collect(Collectors.toSet());
        List orgVos = Optional.ofNullable(this.orgVoService.findByOrgCodes(new ArrayList(orgCodeSet))).orElse(new ArrayList());
        Map orgVoMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
        List<UserPositionVo> userPositionVoList = this.userPositionService.listByUserNameList(new ArrayList<String>(userNameSet));
        List<UserPositionVo> parentUserPositionVoList = this.userPositionService.listByUserNameList(new ArrayList<String>(mdgParentCodeSet));
        List positionCodeList = parentUserPositionVoList.stream().map(UserPositionVo::getPositionCode).collect(Collectors.toList());
        List byIdsOrCodes = this.positionVoService.findByIdsOrCodes(null, positionCodeList);
        Map positionMap = byIdsOrCodes.stream().collect(Collectors.toMap(PositionVo::getPositionCode, Function.identity()));
        Map<String, List<UserPositionVo>> parentUserPositionMap = parentUserPositionVoList.stream().collect(Collectors.groupingBy(UserPositionVo::getUserName));
        Map<String, List<UserPositionVo>> userPositionMap = userPositionVoList.stream().collect(Collectors.groupingBy(UserPositionVo::getUserName));
        ArrayList<UserDto> pullList = new ArrayList<UserDto>();
        ArrayList failList = new ArrayList();
        masterDataMdgUserVos.forEach(masterDataMdgUserVo -> {
            if (StringUtils.isEmpty((CharSequence)masterDataMdgUserVo.getHRSTATUS()) || EffStatusEnum.DISABLE.getCode().equals(masterDataMdgUserVo.getHRSTATUS())) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)masterDataMdgUserVo.getEMPLID())) {
                failList.add(masterDataMdgUserVo);
                return;
            }
            if (StringUtils.equals((CharSequence)masterDataMdgUserVo.getEMPLID(), (CharSequence)masterDataMdgUserVo.getMNJOBEMPLID())) {
                failList.add(masterDataMdgUserVo);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)masterDataMdgUserVo.getDEPTID())) {
                failList.add(masterDataMdgUserVo);
                return;
            }
            if (!mdgPositionVoMap.containsKey(masterDataMdgUserVo.getPOSITIONNBR())) {
                failList.add(masterDataMdgUserVo);
                return;
            }
            if (orgVoMap.containsKey(masterDataMdgUserVo.getDEPTID())) {
                failList.add(masterDataMdgUserVo);
                return;
            }
            UserDto userDto = new UserDto();
            List userVos = Optional.ofNullable(codeMap.get(masterDataMdgUserVo.getEMPLID())).orElse(new ArrayList());
            userVos.add(masterDataMdgUserVo);
            if (userVos.size() > 1) {
                throw new RuntimeException("\u6570\u636e\uff1a" + JSON.toJSONString((Object)userVos) + "\u91cd\u590d\u62c9\u53d6\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            codeMap.put(masterDataMdgUserVo.getEMPLID(), userVos);
            userDto.setUserName(masterDataMdgUserVo.getEMPLID());
            userDto.setFullName(masterDataMdgUserVo.getNAME());
            userDto.setUserPhone(masterDataMdgUserVo.getMNCELLPHONE());
            userDto.setCostCenterCode(masterDataMdgUserVo.getMN_SALARY_CENTER());
            userDto.setEmployeeStatus(masterDataMdgUserVo.getHRSTATUS());
            userDto.setUserSource(UserSourceEnum.MDG.getCode());
            userDto.setMdgParentUserName(masterDataMdgUserVo.getMNJOBEMPLID());
            ArrayList<UserPositionDto> positionList = new ArrayList<UserPositionDto>();
            UserPositionDto userPositionDto = new UserPositionDto();
            userPositionDto.setUserName(userDto.getUserName());
            userPositionDto.setMdgPositionCode(masterDataMdgUserVo.getPOSITIONNBR());
            userPositionDto.setPositionSource(PositionSourceEnum.MDG.getCode());
            if (masterDataMdgUserVoMap.containsKey(masterDataMdgUserVo.getMNJOBEMPLID())) {
                MasterDataMdgUserVo parentUser = (MasterDataMdgUserVo)masterDataMdgUserVoMap.get(masterDataMdgUserVo.getMNJOBEMPLID());
                if (ObjectUtils.isEmpty((Object)parentUser)) {
                    userPositionDto.setMdgParentCode(parentUser.getPOSITIONNBR());
                }
            } else if (parentUserPositionMap.containsKey(masterDataMdgUserVo.getMNJOBEMPLID())) {
                ((List)parentUserPositionMap.get(masterDataMdgUserVo.getMNJOBEMPLID())).forEach(parentUserPositionVo -> {
                    if (PositionSourceEnum.MDG.getCode().equals(parentUserPositionVo.getPositionSource())) {
                        userPositionDto.setMdgParentCode(((PositionVo)positionMap.get(parentUserPositionVo.getPositionCode())).getMdgPositionCode());
                    }
                });
            } else {
                failList.add(masterDataMdgUserVo);
                return;
            }
            if (userPositionMap.containsKey(userDto.getUserName())) {
                ((List)userPositionMap.get(userDto.getUserName())).forEach(userPositionVo -> {
                    if (userPositionVo.getPositionCode().equals(masterDataMdgUserVo.getPOSITIONNBR())) {
                        userPositionDto.setPrimaryFlag(userPositionVo.getPrimaryFlag());
                    }
                });
            } else {
                userPositionDto.setPrimaryFlag(Boolean.valueOf(true));
            }
            userPositionDto.setOperationType(Boolean.valueOf(false));
            positionList.add(userPositionDto);
            userDto.setPositionList(positionList);
            pullList.add(userDto);
        });
        log.info("\u62c9\u53d6\u7528\u6237\u5931\u8d25\u7684\u6570\u636e\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014>" + JSON.toJSONString(failList));
        return pullList;
    }

    private List<UserDto> userValidate(List<MasterDataMdgUserVo> masterDataMdgUserVos, List<MasterDataMdgUserVo> successList) {
        Set mdgPositionCodeSet = masterDataMdgUserVos.stream().map(MasterDataMdgUserVo::getPOSITIONNBR).filter(Objects::nonNull).collect(Collectors.toSet());
        HashMap codeMap = new HashMap(8);
        List mdgPositionVoList = this.positionVoService.findByMdgPositionCodeList(new ArrayList(mdgPositionCodeSet));
        Map mdgPositionVoMap = mdgPositionVoList.stream().collect(Collectors.toMap(PositionVo::getMdgPositionCode, Function.identity(), (oldVo, newVo) -> newVo));
        Set orgCodeSet = masterDataMdgUserVos.stream().map(MasterDataMdgUserVo::getDEPTID).filter(Objects::nonNull).collect(Collectors.toSet());
        List orgVos = Optional.ofNullable(this.orgVoService.findByOrgCodes(new ArrayList(orgCodeSet))).orElse(new ArrayList());
        Map orgVoMap = orgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
        ArrayList<UserDto> pullList = new ArrayList<UserDto>();
        ArrayList failList = new ArrayList();
        HashMap<String, List> dupPhoneMap = new HashMap<String, List>();
        masterDataMdgUserVos.forEach(masterDataMdgUserVo -> {
            if (StringUtils.isEmpty((CharSequence)masterDataMdgUserVo.getHRSTATUS()) || EffStatusEnum.DISABLE.getCode().equals(masterDataMdgUserVo.getHRSTATUS())) {
                failList.add(masterDataMdgUserVo);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)masterDataMdgUserVo.getEMPLID())) {
                failList.add(masterDataMdgUserVo);
                return;
            }
            if (StringUtils.equals((CharSequence)masterDataMdgUserVo.getEMPLID(), (CharSequence)masterDataMdgUserVo.getMNJOBEMPLID())) {
                failList.add(masterDataMdgUserVo);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)masterDataMdgUserVo.getDEPTID())) {
                failList.add(masterDataMdgUserVo);
                return;
            }
            if (!mdgPositionVoMap.containsKey(masterDataMdgUserVo.getPOSITIONNBR())) {
                failList.add(masterDataMdgUserVo);
                return;
            }
            if (!orgVoMap.containsKey(masterDataMdgUserVo.getDEPTID())) {
                failList.add(masterDataMdgUserVo);
                return;
            }
            if (StringUtils.isEmpty((CharSequence)masterDataMdgUserVo.getMNCELLPHONE())) {
                failList.add(masterDataMdgUserVo);
                return;
            }
            UserDto userDto = new UserDto();
            List userVos = Optional.ofNullable(codeMap.get(masterDataMdgUserVo.getEMPLID())).orElse(new ArrayList());
            userVos.add(masterDataMdgUserVo);
            if (userVos.size() > 1) {
                throw new RuntimeException("\u6570\u636e\uff1a" + JSON.toJSONString((Object)userVos) + "\u91cd\u590d\u62c9\u53d6\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (dupPhoneMap.containsKey(masterDataMdgUserVo.getMNCELLPHONE())) {
                List dupPhoneList = (List)dupPhoneMap.get(masterDataMdgUserVo.getMNCELLPHONE());
                dupPhoneList.add(masterDataMdgUserVo.getEMPLID());
                dupPhoneMap.put(masterDataMdgUserVo.getMNCELLPHONE(), dupPhoneList);
                failList.add(masterDataMdgUserVo);
                return;
            }
            ArrayList<String> dupPhoneList = new ArrayList<String>();
            dupPhoneList.add(masterDataMdgUserVo.getEMPLID());
            dupPhoneMap.put(masterDataMdgUserVo.getMNCELLPHONE(), dupPhoneList);
            codeMap.put(masterDataMdgUserVo.getEMPLID(), userVos);
            userDto.setUserName(masterDataMdgUserVo.getEMPLID());
            userDto.setFullName(masterDataMdgUserVo.getNAME());
            userDto.setUserPhone(masterDataMdgUserVo.getMNCELLPHONE());
            userDto.setCostCenterCode(masterDataMdgUserVo.getMN_SALARY_CENTER());
            userDto.setEmployeeStatus(masterDataMdgUserVo.getHRSTATUS());
            userDto.setUserSource(UserSourceEnum.MDG.getCode());
            userDto.setMdgParentUserName(masterDataMdgUserVo.getMNJOBEMPLID());
            pullList.add(userDto);
            successList.add((MasterDataMdgUserVo)masterDataMdgUserVo);
        });
        log.info("\u62c9\u53d6\u7528\u6237\u5931\u8d25\u7684\u6570\u636e\u5171" + failList.size() + "\u6761\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014>" + JSON.toJSONString(failList));
        ArrayList userNameList = new ArrayList();
        if (MapUtils.isNotEmpty(dupPhoneMap)) {
            dupPhoneMap.forEach((key, value) -> {
                if (value.size() > 1) {
                    userNameList.addAll(value);
                }
            });
        }
        log.info("\u624b\u673a\u53f7\u7801\u91cd\u590d\u7684\u7528\u6237\u5171\uff1a" + userNameList.size() + "\u6761\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014>" + JSON.toJSONString(userNameList));
        return pullList;
    }

    private void unLock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6\u5458\u5de5\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisMutexService.unlock("user_lock:lock:" + yearMonthDay);
    }

    private boolean lock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6\u5458\u5de5\u52a0\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisMutexService.tryLock("user_lock:lock:" + yearMonthDay, TimeUnit.HOURS, 12);
    }
}

