/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.enums.LockStateEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.position.sdk.dto.PositionDto;
import com.biz.crm.mdm.business.position.sdk.dto.PositionRelationDto;
import com.biz.crm.mdm.business.position.sdk.dto.RelationDataDto;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.local.entity.UserEntity;
import com.biz.crm.mdm.business.user.local.entity.UserPositionEntity;
import com.biz.crm.mdm.business.user.local.repository.UserPositionRepository;
import com.biz.crm.mdm.business.user.local.repository.UserRepository;
import com.biz.crm.mdm.business.user.sdk.dto.UserChangePasswordDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserForceChangePasswordDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserPageDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserPositionDto;
import com.biz.crm.mdm.business.user.sdk.enums.UserTypeEnum;
import com.biz.crm.mdm.business.user.sdk.event.UserEventListener;
import com.biz.crm.mdm.business.user.sdk.service.UserPositionVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.Aes128Utils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.password.PasswordValidateService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;

@Service
public class UserVoServiceImpl
implements UserVoService {
    private static final Logger log = LoggerFactory.getLogger(UserVoServiceImpl.class);
    @Autowired(required=false)
    private UserRepository userRepository;
    @Autowired(required=false)
    private PositionVoService positionVoService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private UserPositionVoService userPositionVoService;
    @Autowired(required=false)
    @Lazy
    private List<UserEventListener> userEventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private UserPositionRepository userPositionRepository;
    @Autowired(required=false)
    private OrgPositionVoService orgPositionVoService;
    @Autowired(required=false)
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private PasswordValidateService passwordValidateService;

    public Page<UserVo> findByConditions(Pageable pageable, UserPageDto dto) {
        return this.userRepository.findByConditions(pageable, dto);
    }

    public UserVo findDetailById(String id) {
        List positionCodes;
        List orgPositionVos;
        List<UserPositionEntity> userPositions;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        UserEntity entity = this.userRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (entity == null) {
            return null;
        }
        UserVo userVo = (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (StringUtils.isNotBlank((CharSequence)userVo.getSysLoginPort())) {
            userVo.setSysLoginPorts(Arrays.asList(userVo.getSysLoginPort().split(",")));
        }
        if (CollectionUtils.isEmpty(userPositions = this.userPositionRepository.findByUserName(TenantUtils.getTenantCode(), userVo.getUserName()))) {
            return userVo;
        }
        List userPositionVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(userPositions, UserPositionEntity.class, UserPositionVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty(userPositions) && !CollectionUtils.isEmpty((Collection)(orgPositionVos = this.orgPositionVoService.findByPositionCodes(positionCodes = userPositions.stream().map(UserPositionEntity::getPositionCode).collect(Collectors.toList()))))) {
            Map<String, List<OrgPositionVo>> orgPositionVoMap = orgPositionVos.stream().collect(Collectors.groupingBy(OrgPositionVo::getPositionCode));
            for (UserPositionVo userPositionVo : userPositionVos) {
                List<OrgPositionVo> orgPositionVoList = orgPositionVoMap.get(userPositionVo.getPositionCode());
                if (CollectionUtils.isEmpty(orgPositionVoList)) continue;
                Set orgCodes = orgPositionVoList.stream().map(OrgPositionVo::getOrgCode).collect(Collectors.toSet());
                userPositionVo.setOrgCodes(orgCodes);
            }
        }
        userVo.setPositionList(userPositionVos);
        return userVo;
    }

    public UserVo findByUserName(String userName) {
        Optional<UserPositionVo> currentOptional;
        List userPosits;
        if (StringUtils.isBlank((CharSequence)userName)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        UserEntity entity = this.userRepository.findByUserName(tenantCode, userName);
        if (entity == null) {
            return null;
        }
        UserVo userVo = (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (StringUtils.isNotBlank((CharSequence)userVo.getSysLoginPort())) {
            userVo.setSysLoginPorts(Arrays.asList(userVo.getSysLoginPort().split(",")));
        }
        if (!CollectionUtils.isEmpty((Collection)(userPosits = this.userPositionVoService.findByUserName(tenantCode, userName))) && (currentOptional = userPosits.stream().filter(f -> Boolean.TRUE.equals(f.getCurrentFlag())).findFirst()).isPresent()) {
            userVo.setPositionCode(currentOptional.get().getPositionCode());
            OrgVo orgVo = this.orgPositionVoService.findByPositionCode(currentOptional.get().getPositionCode());
            if (ObjectUtils.isNotEmpty((Object)orgVo)) {
                userVo.setOrgCode(orgVo.getOrgCode());
                userVo.setOrgName(orgVo.getOrgName());
            }
        }
        return userVo;
    }

    @Transactional
    public void create(UserDto dto) {
        this.createValidation(dto);
        this.validationPosition(dto);
        if (StringUtils.isBlank((CharSequence)dto.getUserCode())) {
            List codeList = this.generateCodeService.generateCode("YH", 1);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)codeList), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u751f\u6210\u7528\u6237\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
            UserEntity dbEntity = this.userRepository.findByUserCode(TenantUtils.getTenantCode(), (String)codeList.get(0));
            Validate.isTrue((boolean)Objects.isNull((Object)dbEntity), (String)String.format("\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7528\u6237\u7f16\u7801[%s]\u5df2\u5b58\u5728\uff01", codeList.get(0)), (Object[])new Object[0]);
            dto.setUserCode((String)codeList.get(0));
        } else {
            UserEntity dbEntity = this.userRepository.findByUserCode(TenantUtils.getTenantCode(), dto.getUserCode());
            Validate.isTrue((boolean)Objects.isNull((Object)dbEntity), (String)String.format("\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7528\u6237\u7f16\u7801[%s]\u5df2\u5b58\u5728\uff01", dto.getUserCode()), (Object[])new Object[0]);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setLockState(LockStateEnum.UNLOCK.getCode());
        dto.setForceChangePassword(Boolean.TRUE);
        dto.setUpdatePasswordDate(new Date());
        Validate.isTrue((boolean)StringUtils.equalsAny((CharSequence)dto.getUserType(), (CharSequence[])new CharSequence[]{UserTypeEnum.USER.getCode(), UserTypeEnum.USER_GUIDE.getCode()}), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6,\u7528\u6237\u7c7b\u578b\u975e\u4f01\u4e1a\u7528\u6237\u3010%s\u3011\u548c\u4f01\u4e1a\u5bfc\u8d2d\u7528\u6237\u3010%s\u3011", (Object[])new Object[]{UserTypeEnum.USER.getCode(), UserTypeEnum.USER_GUIDE.getCode()});
        UserEntity entity = (UserEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, UserEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.userRepository.saveOrUpdate((Object)entity);
        this.rebindUserPositionRelation(dto);
        if (CollectionUtils.isNotEmpty(this.userEventListeners)) {
            UserVo vo = (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.userEventListeners.forEach(event -> event.onCreate(vo));
        }
    }

    public void createMdgBatch(List<UserDto> saveList) {
        this.createValidationBatch(saveList);
        List userEntities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(saveList, UserDto.class, UserEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.rebindUserPositionRelationBatch(saveList, userEntities);
    }

    public void updateMdgBatch(List<UserDto> updateList) {
        this.updateValidationBatch(updateList);
        List userEntities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(updateList, UserDto.class, UserEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.rebindUserPositionRelationBatch(updateList, userEntities);
    }

    public List<UserVo> listByUserPhone(List<String> userPhoneList) {
        if (CollectionUtils.isEmpty(userPhoneList)) {
            return Lists.newArrayList();
        }
        List<UserEntity> userEntityList = this.userRepository.listByUserPhone(userPhoneList);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(userEntityList, UserEntity.class, UserVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<UserVo> findUserByOrgCodes(List<String> orgCodeList) {
        return this.userRepository.findUserByOrgCodes(orgCodeList);
    }

    public List<UserVo> findByUserNames(List<String> userNameList) {
        if (CollectionUtils.isEmpty(userNameList)) {
            return Lists.newArrayList();
        }
        List<UserEntity> userEntityList = this.userRepository.findByUserNames(userNameList);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(userEntityList, UserEntity.class, UserVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public UserVo findUserAllMsgByUserName(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return null;
        }
        return this.userRepository.findUserAllMsgByUserName(userName);
    }

    private void updateValidationBatch(List<UserDto> updateList) {
        List<String> userNameList = updateList.stream().map(UserDto::getUserName).filter(Objects::nonNull).collect(Collectors.toList());
        List<UserEntity> byUserNames = this.userRepository.findByUserNames(TenantUtils.getTenantCode(), userNameList);
        Map userEntityMap = byUserNames.stream().collect(Collectors.toMap(UserEntity::getUserName, Function.identity()));
        updateList.forEach(update -> {
            Validate.notBlank((CharSequence)update.getUserPassword(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)update.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)update.getUserCode(), (String)"\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)update.getPositionList()), (String)"\u5173\u8054\u7684\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            UserEntity userEntity = (UserEntity)((Object)((Object)userEntityMap.get(update.getUserName())));
            Validate.notNull((Object)((Object)userEntity), (String)"\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u5220\u9664", (Object[])new Object[0]);
            for (UserPositionDto item : update.getPositionList()) {
                Validate.notBlank((CharSequence)item.getOrgCode(), (String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)item.getOperationType(), (String)"\u662f\u5426\u65b0\u589e\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)item.getPrimaryFlag(), (String)"\u662f\u5426\u4e3b\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                if (item.getOperationType().booleanValue()) continue;
                Validate.notBlank((CharSequence)item.getPositionCode(), (String)"\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                if (!StringUtils.isNotBlank((CharSequence)item.getParentCode())) continue;
                Validate.isTrue((!item.getParentCode().equals(item.getPositionCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u662f\u81ea\u5df1", (Object[])new Object[0]);
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    void rebindUserPositionRelationBatch(List<UserDto> saveList, List<UserEntity> userEntities) {
        ArrayList positionDtoList = new ArrayList();
        ArrayList userPositionDtoList = new ArrayList();
        saveList.forEach(save -> {
            userPositionDtoList.add(save.getPositionList().get(0));
            for (UserPositionDto item : save.getPositionList()) {
                PositionDto positionDto = (PositionDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, PositionDto.class, HashSet.class, ArrayList.class, new String[0]);
                ArrayList<PositionRelationDto> positionRelationDtos = new ArrayList<PositionRelationDto>();
                PositionRelationDto positionRelationDto = new PositionRelationDto();
                positionRelationDto.setRelationKey("org");
                positionRelationDto.setRelationName("\u7ec4\u7ec7");
                ArrayList<RelationDataDto> relationDataDtos = new ArrayList<RelationDataDto>();
                RelationDataDto relationDataDto = new RelationDataDto();
                relationDataDto.setCode(item.getOrgCode());
                relationDataDtos.add(relationDataDto);
                positionRelationDto.setRelationData(relationDataDtos);
                positionRelationDtos.add(positionRelationDto);
                positionDto.setRelationData(positionRelationDtos);
                positionDtoList.add(positionDto);
            }
        });
        this.userRepository.saveOrUpdateBatch(userEntities);
        this.positionVoService.updateMdgBatch(positionDtoList);
        this.userPositionVoService.rebindMdgUser(userPositionDtoList);
    }

    private void createValidationBatch(List<UserDto> saveList) {
        List<String> userNameList = saveList.stream().map(UserDto::getUserName).filter(Objects::nonNull).collect(Collectors.toList());
        List<UserEntity> byUserNames = this.userRepository.findByUserNames(TenantUtils.getTenantCode(), userNameList);
        Map userEntityMap = byUserNames.stream().collect(Collectors.toMap(UserEntity::getUserName, Function.identity()));
        List codeList = this.generateCodeService.generateCode("YH", saveList.size());
        ListIterator codeIterator = codeList.listIterator();
        saveList.forEach(save -> {
            save.setId(null);
            if (userEntityMap.containsKey(save.getUserName())) {
                throw new RuntimeException("\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728\uff08\u6216\u5df2\u903b\u8f91\u5220\u9664\uff09");
            }
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)save.getPositionList()), (String)"\u5173\u8054\u7684\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            if (BooleanEnum.TRUE.getCapital().equals(save.getMd5Flag())) {
                String password = Aes128Utils.decrypt((CharSequence)save.getUserPassword(), (String)"1234123412ABCDEF", (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
                String md5Password = DigestUtils.md5DigestAsHex((byte[])password.getBytes(StandardCharsets.UTF_8));
                save.setUserPassword(md5Password);
            }
            save.setUserCode((String)codeIterator.next());
            save.setTenantCode(TenantUtils.getTenantCode());
            save.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            save.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            save.setLockState(EnableStatusEnum.ENABLE.getCode());
            save.setForceChangePassword(Boolean.TRUE);
            save.setUpdatePasswordDate(new Date());
            for (UserPositionDto item : save.getPositionList()) {
                Validate.notNull((Object)item.getOperationType(), (String)"\u662f\u5426\u65b0\u589e\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)item.getPrimaryFlag(), (String)"\u662f\u5426\u4e3b\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)item.getPositionCode(), (String)"\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                if (!StringUtils.isNotBlank((CharSequence)item.getParentCode())) continue;
                Validate.isTrue((!item.getParentCode().equals(item.getPositionCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u662f\u81ea\u5df1", (Object[])new Object[0]);
            }
        });
    }

    @Transactional
    public void update(UserDto dto) {
        this.updateValidation(dto);
        this.validationPosition(dto);
        UserEntity oldEntity = this.userRepository.findByIdAndTenantCode(dto.getId(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)oldEntity), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        UserEntity entity = (UserEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, UserEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.userRepository.saveOrUpdate((Object)entity);
        this.rebindUserPositionRelation(dto);
        if (CollectionUtils.isNotEmpty(this.userEventListeners)) {
            UserVo oldVo = (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
            UserVo materialVo = (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.userEventListeners.forEach(event -> event.onUpdate(oldVo, materialVo));
        }
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<UserEntity> entities = this.userRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.userRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        if (CollectionUtils.isNotEmpty(this.userEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, UserEntity.class, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.userEventListeners.forEach(event -> event.onEnable(voList));
        }
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<UserEntity> entities = this.userRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.userRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (CollectionUtils.isNotEmpty(this.userEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, UserEntity.class, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.userEventListeners.forEach(event -> event.onDisable(voList));
        }
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<UserEntity> entities = this.userRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.userRepository.updateDelFlagByIds(ids);
        List userNameList = entities.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getUserName())).map(UserEntity::getUserName).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(userNameList)) {
            this.userPositionVoService.deleteByUserNames(userNameList);
        }
        if (CollectionUtils.isNotEmpty(this.userEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, UserEntity.class, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.userEventListeners.forEach(event -> event.onDelete(voList));
        }
    }

    public void rebindUserPositionRelation(UserDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getPositionList())) {
            this.userPositionVoService.deleteByUserNames(Collections.singletonList(dto.getUserName()));
            return;
        }
        for (UserPositionDto item : dto.getPositionList()) {
            PositionVo positionVo;
            OrgVo org = this.orgVoService.findByOrgCode(item.getOrgCode());
            Validate.notNull((Object)org, (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            PositionDto positionDto = (PositionDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, PositionDto.class, HashSet.class, ArrayList.class, new String[0]);
            positionDto.setRoleCodeList(item.getRoleCodeList());
            ArrayList<PositionRelationDto> positionRelationDtos = new ArrayList<PositionRelationDto>();
            PositionRelationDto positionRelationDto = new PositionRelationDto();
            positionRelationDto.setRelationKey("org");
            positionRelationDto.setRelationName("\u7ec4\u7ec7");
            ArrayList<RelationDataDto> relationDataDtos = new ArrayList<RelationDataDto>();
            RelationDataDto relationDataDto = new RelationDataDto();
            relationDataDto.setCode(org.getOrgCode());
            relationDataDtos.add(relationDataDto);
            positionRelationDto.setRelationData(relationDataDtos);
            positionRelationDtos.add(positionRelationDto);
            positionDto.setRelationData(positionRelationDtos);
            if (item.getOperationType().booleanValue()) {
                positionVo = this.positionVoService.create(positionDto);
                item.setPositionCode(positionVo.getPositionCode());
                continue;
            }
            Validate.notBlank((CharSequence)item.getPositionCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            positionVo = this.positionVoService.findByPositionCode(item.getPositionCode());
            Validate.notNull((Object)positionVo, (String)"\u804c\u4f4d\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            positionDto.setId(positionVo.getId());
            item.setMdgPositionCode(positionVo.getMdgPositionCode());
            this.positionVoService.update(positionDto);
        }
        List primaryPositionCodeList = dto.getPositionList().stream().filter(i -> Boolean.TRUE.equals(i.getPrimaryFlag())).map(UserPositionDto::getPositionCode).collect(Collectors.toList());
        Validate.isTrue((primaryPositionCodeList.size() <= 1 ? 1 : 0) != 0, (String)"\u4e00\u4e2a\u7528\u6237\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u4e3b\u804c\u4f4d", (Object[])new Object[0]);
        String primaryPositionCode = null;
        if (CollectionUtils.isNotEmpty(primaryPositionCodeList)) {
            primaryPositionCode = (String)primaryPositionCodeList.get(0);
        }
        List positionCodeList = dto.getPositionList().stream().map(UserPositionDto::getPositionCode).distinct().collect(Collectors.toList());
        this.userPositionVoService.rebindByUserName(dto.getUserName(), primaryPositionCode, positionCodeList, dto.getPositionList());
    }

    private void createValidation(UserDto dto) {
        dto.setId(null);
        this.validation(dto);
        if (CollectionUtils.isNotEmpty((Collection)dto.getSysLoginPorts())) {
            dto.setSysLoginPort(Strings.join((Iterable)dto.getSysLoginPorts(), (String)","));
        }
        UserEntity byUserNameCoverDel = this.userRepository.findByUserNameCoverDel(TenantUtils.getTenantCode(), dto.getUserName());
        Validate.isTrue((boolean)Objects.isNull((Object)byUserNameCoverDel), (String)"\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728\uff08\u6216\u5df2\u903b\u8f91\u5220\u9664\uff09", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getUserPassword(), (String)"\u7528\u6237\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getPositionList()), (String)"\u5173\u8054\u7684\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        log.info("HttpServletRequest userPassword:{}", (Object)dto.getUserPassword());
        String password = Aes128Utils.decrypt((CharSequence)dto.getUserPassword(), (String)"1234123412ABCDEF", (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
        String md5Password = DigestUtils.md5DigestAsHex((byte[])password.getBytes(StandardCharsets.UTF_8));
        dto.setUserPassword(md5Password);
    }

    private void updateValidation(UserDto dto) {
        this.validation(dto);
        Validate.notBlank((CharSequence)dto.getUserPassword(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getUserCode(), (String)"\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserEntity dbEntity = this.userRepository.findByIdAndTenantCode(dto.getId(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)dbEntity), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u5220\u9664", (Object[])new Object[0]);
        Validate.isTrue((boolean)dbEntity.getUserName().equals(dto.getUserName()), (String)"\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getPositionList()), (String)"\u5173\u8054\u7684\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)dto.getUserPassword())) {
            log.info("HttpServletRequest userPassword:{}", (Object)dto.getUserPassword());
            String password = Aes128Utils.decrypt((CharSequence)dto.getUserPassword(), (String)"1234123412ABCDEF", (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
            this.passwordValidateService.validate(password);
            if (!password.equals(dbEntity.getUserPassword())) {
                String md5Password = DigestUtils.md5DigestAsHex((byte[])password.getBytes(StandardCharsets.UTF_8));
                dto.setUserPassword(md5Password);
                dto.setUpdatePasswordDate(new Date());
            } else {
                dto.setUserPassword(dbEntity.getUserPassword());
            }
        } else {
            dto.setUserPassword(dbEntity.getUserPassword());
        }
    }

    private void validation(UserDto dto) {
        List list;
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getUserName(), (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFullName(), (String)"\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getUserPhone(), (String)"\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<UserEntity> UserByPhone = this.userRepository.findByUserPhone(TenantUtils.getTenantCode(), dto.getUserPhone());
        if (StringUtils.isNotBlank((CharSequence)dto.getId())) {
            list = UserByPhone.stream().filter(x -> StringUtils.isNotBlank((CharSequence)dto.getId()) && !dto.getId().equals(x.getId())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u7535\u8bdd\u53f7\u7801\u5df2\u7ecf\u88ab\u5360\u7528", (Object[])new Object[0]);
        } else {
            Validate.isTrue((boolean)CollectionUtils.isEmpty(UserByPhone), (String)"\u7535\u8bdd\u53f7\u7801\u5df2\u7ecf\u88ab\u5360\u7528", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getEmail())) {
            list = this.userRepository.findByEmail(TenantUtils.getTenantCode(), dto.getEmail()).stream().filter(x -> StringUtils.isNotBlank((CharSequence)dto.getId()) && !dto.getId().equals(x.getId())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u90ae\u7bb1\u5df2\u7ecf\u88ab\u5360\u7528", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getIdentityCardNumber())) {
            list = this.userRepository.findByIdentityCardNumber(TenantUtils.getTenantCode(), dto.getIdentityCardNumber()).stream().filter(x -> StringUtils.isNotBlank((CharSequence)dto.getId()) && !dto.getId().equals(x.getId())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u8eab\u4efd\u8bc1\u53f7\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
        if (CollectionUtils.isEmpty((Collection)dto.getPositionList())) {
            return;
        }
        List primaryPositionCodeList = dto.getPositionList().stream().filter(i -> Boolean.TRUE.equals(i.getPrimaryFlag())).map(UserPositionDto::getPositionCode).collect(Collectors.toList());
        Validate.isTrue((primaryPositionCodeList.size() <= 1 ? 1 : 0) != 0, (String)"\u4e00\u4e2a\u7528\u6237\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u4e3b\u804c\u4f4d", (Object[])new Object[0]);
        for (UserPositionDto item : dto.getPositionList()) {
            Validate.notBlank((CharSequence)item.getOrgCode(), (String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)item.getOperationType(), (String)"\u662f\u5426\u65b0\u589e\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)item.getPrimaryFlag(), (String)"\u662f\u5426\u4e3b\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (item.getOperationType().booleanValue()) {
                item.setPositionName(item.getPositionCode());
                item.setPositionCode(null);
                continue;
            }
            Validate.notBlank((CharSequence)item.getPositionCode(), (String)"\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (!StringUtils.isNotBlank((CharSequence)item.getParentCode())) continue;
            Validate.isTrue((!item.getParentCode().equals(item.getPositionCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u662f\u81ea\u5df1", (Object[])new Object[0]);
        }
    }

    @Transactional
    public void deleteUserLockByIds(List<String> ids) {
        Validate.notEmpty(ids, (String)"ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<UserEntity> list = this.userRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        list.forEach(item -> {
            for (int i = 1; i < 7; ++i) {
                String account = StringUtils.join((Object[])new String[]{i + "", "_", item.getUserName()});
                String redisKey = String.format("crm:login:failed:%s:%s", tenantCode, account);
                this.stringRedisTemplate.delete((Object)redisKey);
            }
        });
    }

    @Transactional
    public void updatePasswordByIds(UserForceChangePasswordDto dto) {
        Validate.notEmpty((Collection)dto.getIds(), (String)"ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801", (Object[])new Object[0]);
        log.info("HttpServletRequest password:{}", (Object)dto.getPassword());
        List<UserEntity> entities = this.userRepository.findByIds(dto.getIds());
        Validate.notEmpty(entities, (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", (Object[])new Object[0]);
        Set idSet = entities.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        dto.getIds().forEach(id -> Validate.isTrue((boolean)idSet.contains(id), (String)String.format("\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664ID:%s", id), (Object[])new Object[0]));
        String password = Aes128Utils.decrypt((CharSequence)dto.getPassword(), (String)"1234123412ABCDEF", (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
        String passwordEncryption = DigestUtils.md5DigestAsHex((byte[])password.getBytes(StandardCharsets.UTF_8));
        this.userRepository.updatePasswordByIds(dto.getIds(), passwordEncryption);
    }

    @Transactional
    public void updatePasswordByUserName(UserChangePasswordDto dto) {
        Validate.notBlank((CharSequence)dto.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOldPassword(), (String)"\u7f3a\u5931\u539f\u5bc6\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getNewPassword(), (String)"\u7f3a\u5931\u65b0\u5bc6\u7801", (Object[])new Object[0]);
        log.info("HttpServletRequest oldPassword:{}", (Object)dto.getOldPassword());
        log.info("HttpServletRequest newPassword:{}", (Object)dto.getNewPassword());
        this.isStrongPwd(dto.getNewPassword());
        UserEntity entity = this.userRepository.findByUserName(TenantUtils.getTenantCode(), dto.getUserName());
        Validate.notNull((Object)((Object)entity), (String)"\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", (Object[])new Object[0]);
        String oldPassword = Aes128Utils.decrypt((CharSequence)dto.getOldPassword(), (String)"1234123412ABCDEF", (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
        String newPassword = Aes128Utils.decrypt((CharSequence)dto.getNewPassword(), (String)"1234123412ABCDEF", (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
        String oldPasswordEncryption = DigestUtils.md5DigestAsHex((byte[])oldPassword.getBytes(StandardCharsets.UTF_8));
        String newPasswordEncryption = DigestUtils.md5DigestAsHex((byte[])newPassword.getBytes(StandardCharsets.UTF_8));
        Validate.isTrue((boolean)entity.getUserPassword().equals(oldPasswordEncryption), (String)"\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((!oldPasswordEncryption.equals(newPasswordEncryption) ? 1 : 0) != 0, (String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u539f\u5bc6\u7801\u76f8\u540c", (Object[])new Object[0]);
        entity.setUserPassword(newPasswordEncryption);
        entity.setUpdatePasswordDate(new Date());
        entity.setForceChangePassword(Boolean.FALSE);
        this.userRepository.updateByIdAndTenantCode(entity, TenantUtils.getTenantCode());
    }

    public Set<String> findUserNamesByCodesAndUserType(List<String> orgCodes, List<String> positionLevelCodes, String userType) {
        if (CollectionUtils.isEmpty(orgCodes) && CollectionUtils.isEmpty(positionLevelCodes)) {
            return new HashSet<String>();
        }
        HashSet<String> positionCodes = new HashSet();
        Set positionCodesByOrgCodes = this.orgPositionVoService.findPositionCodesByOrgCodes(orgCodes);
        Set positionCodesByPositionLevelCodes = this.positionVoService.findPositionCodesByPositionLevelCodes(positionLevelCodes);
        if (!CollectionUtils.isEmpty((Collection)positionCodesByOrgCodes) && !CollectionUtils.isEmpty((Collection)positionCodesByPositionLevelCodes)) {
            positionCodesByOrgCodes.retainAll(positionCodesByOrgCodes);
            positionCodes = positionCodesByOrgCodes;
        } else if (!CollectionUtils.isEmpty((Collection)positionCodesByOrgCodes) && CollectionUtils.isEmpty((Collection)positionCodesByPositionLevelCodes)) {
            positionCodes = positionCodesByOrgCodes;
        } else if (CollectionUtils.isEmpty((Collection)positionCodesByOrgCodes) && !CollectionUtils.isEmpty((Collection)positionCodesByPositionLevelCodes)) {
            positionCodes = positionCodesByPositionLevelCodes;
        } else {
            return new HashSet<String>();
        }
        List<UserPositionEntity> byPositionCode = this.userPositionRepository.findByPositionCodeIn(TenantUtils.getTenantCode(), positionCodes);
        if (CollectionUtils.isEmpty(byPositionCode)) {
            return new HashSet<String>();
        }
        Set<String> userNames = byPositionCode.stream().map(UserPositionEntity::getUserName).collect(Collectors.toSet());
        List<UserEntity> byUserNamesAndUserType = this.userRepository.findByUserNamesAndUserType(TenantUtils.getTenantCode(), userNames, userType);
        if (CollectionUtils.isEmpty(byUserNamesAndUserType)) {
            return new HashSet<String>();
        }
        return byUserNamesAndUserType.stream().map(UserEntity::getUserName).collect(Collectors.toSet());
    }

    public UserVo findDetailsByPhone(String phone) {
        List positionCodes;
        List orgPositionVos;
        if (StringUtils.isBlank((CharSequence)phone)) {
            return null;
        }
        List<UserEntity> userEntities = this.userRepository.findByUserPhone(TenantUtils.getTenantCode(), phone);
        if (CollectionUtils.isEmpty(userEntities)) {
            return null;
        }
        UserVo userVo = (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)userEntities.get(0), UserVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<UserPositionEntity> userPositions = this.userPositionRepository.findByUserName(TenantUtils.getTenantCode(), userVo.getUserName());
        if (CollectionUtils.isEmpty(userPositions)) {
            return userVo;
        }
        List userPositionVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(userPositions, UserPositionEntity.class, UserPositionVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty(userPositions) && !CollectionUtils.isEmpty((Collection)(orgPositionVos = this.orgPositionVoService.findByPositionCodes(positionCodes = userPositions.stream().map(UserPositionEntity::getPositionCode).collect(Collectors.toList()))))) {
            Map<String, List<OrgPositionVo>> orgPositionVoMap = orgPositionVos.stream().collect(Collectors.groupingBy(OrgPositionVo::getPositionCode));
            for (UserPositionVo userPositionVo : userPositionVos) {
                List<OrgPositionVo> orgPositionVoList = orgPositionVoMap.get(userPositionVo.getPositionCode());
                if (CollectionUtils.isEmpty(orgPositionVoList)) continue;
                Set orgCodes = orgPositionVoList.stream().map(OrgPositionVo::getOrgCode).collect(Collectors.toSet());
                userPositionVo.setOrgCodes(orgCodes);
            }
        }
        userVo.setPositionList(userPositionVos);
        return userVo;
    }

    public UserVo findByPhone(String phone) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            return null;
        }
        List<UserEntity> userEntities = this.userRepository.findByUserPhone(TenantUtils.getTenantCode(), phone);
        if (CollectionUtils.isEmpty(userEntities)) {
            return null;
        }
        return (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)userEntities.get(0), UserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public UserVo findRelationByUserNameAndOrgCodesOrOrgTypes(String userName, List<String> orgCodes, List<String> orgTypes) {
        List allChildrenByOrgTypes;
        if (StringUtils.isBlank((CharSequence)userName)) {
            return null;
        }
        UserEntity userEntity = this.userRepository.findByUserName(TenantUtils.getTenantCode(), userName);
        if (userEntity == null) {
            return null;
        }
        UserVo userVo = (UserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)userEntity, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<UserPositionEntity> userPositionEntities = this.userPositionRepository.findByUserName(TenantUtils.getTenantCode(), userName);
        List positionCodes = Optional.ofNullable(userPositionEntities).orElse(Lists.newArrayList()).stream().map(UserPositionEntity::getPositionCode).collect(Collectors.toList());
        List orgPositionVos = this.orgPositionVoService.findByPositionCodes(positionCodes);
        if (CollectionUtils.isEmpty((Collection)orgPositionVos)) {
            return userVo;
        }
        List userRelationOrgCodes = orgPositionVos.stream().map(OrgPositionVo::getOrgCode).collect(Collectors.toList());
        List userRelationOrgVos = this.orgVoService.findByOrgCodes(userRelationOrgCodes);
        if (CollectionUtils.isEmpty((Collection)userRelationOrgVos)) {
            return userVo;
        }
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            List allChildrenByOrgCodes = this.orgVoService.findAllChildrenByOrgCodes(orgCodes);
            List allChildrenOrgCodes = allChildrenByOrgCodes.stream().map(OrgVo::getOrgCode).distinct().collect(Collectors.toList());
            List relationOrgCodes = userRelationOrgVos.stream().filter(op -> StringUtils.isNotBlank((CharSequence)op.getOrgCode()) && allChildrenOrgCodes.contains(op.getOrgCode())).map(OrgVo::getOrgCode).distinct().collect(Collectors.toList());
            userVo.setRelationOrgCodes(relationOrgCodes);
        }
        if (CollectionUtils.isNotEmpty(orgTypes) && CollectionUtils.isNotEmpty((Collection)(allChildrenByOrgTypes = this.orgVoService.findAllChildrenByOrgTypes(orgTypes)))) {
            List allChildrenOrgTypes = allChildrenByOrgTypes.stream().map(OrgVo::getOrgType).distinct().collect(Collectors.toList());
            List relationOrgTypes = userRelationOrgVos.stream().filter(op -> StringUtils.isNotBlank((CharSequence)op.getOrgType()) && allChildrenOrgTypes.contains(op.getOrgType())).map(OrgVo::getOrgType).distinct().collect(Collectors.toList());
            userVo.setRelationOrgTypes(relationOrgTypes);
        }
        return userVo;
    }

    public Set<String> findUserNamesByUserConditionDto(UserConditionDto dto) {
        if (Objects.isNull(dto)) {
            return Sets.newLinkedHashSet();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return this.userRepository.findUserNamesByUserConditionDto(dto);
    }

    public Set<String> findPositionCodesByUserNames(List<String> userNames) {
        if (CollectionUtils.isEmpty(userNames)) {
            return new HashSet<String>(0);
        }
        List<UserPositionEntity> byUserNames = this.userPositionRepository.findByUserNames(TenantUtils.getTenantCode(), userNames);
        if (CollectionUtils.isEmpty(byUserNames)) {
            return new HashSet<String>(0);
        }
        return byUserNames.stream().filter(UserPositionEntity::getPrimaryFlag).map(UserPositionEntity::getPositionCode).collect(Collectors.toSet());
    }

    public Set<String> findUserNamesByUserNames(List<String> userNameList) {
        if (CollectionUtils.isEmpty(userNameList)) {
            return new HashSet<String>(0);
        }
        List<UserEntity> byUserNames = this.userRepository.findByUserNames(TenantUtils.getTenantCode(), userNameList);
        if (CollectionUtils.isEmpty(byUserNames)) {
            return new HashSet<String>(0);
        }
        return byUserNames.stream().map(UserEntity::getUserName).collect(Collectors.toSet());
    }

    private void isStrongPwd(String pwd) {
        Integer MIN_LENGTH = 8;
        String SMALL_LETTERS = "abcdefghijklmnopqrstuvwxyz";
        String BIG_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String SPECIAL_CHARS = "~!@#$%^&*()_+-={}[],./<>?:|";
        String NUMBERS = "1234567890";
        boolean isLongEnough = pwd.length() >= MIN_LENGTH;
        Validate.isTrue((boolean)isLongEnough, (String)"\u5bc6\u7801\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e8\u4f4d\u6570", (Object[])new Object[0]);
        boolean hasBigLetters = false;
        boolean hasSmallLetters = false;
        boolean hasNumbers = false;
        boolean hasSpecialChars = false;
        int len = pwd.length();
        for (int i = 0; i < len; ++i) {
            if (!hasSmallLetters && "abcdefghijklmnopqrstuvwxyz".indexOf(pwd.charAt(i)) > -1) {
                hasSmallLetters = true;
            }
            if (!hasBigLetters && "ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(pwd.charAt(i)) > -1) {
                hasBigLetters = true;
            }
            if (!hasNumbers && "1234567890".indexOf(pwd.charAt(i)) > -1) {
                hasNumbers = true;
            }
            if (hasSpecialChars || "~!@#$%^&*()_+-={}[],./<>?:|".indexOf(pwd.charAt(i)) <= -1) continue;
            hasSpecialChars = true;
        }
        Validate.isTrue((boolean)hasBigLetters, (String)"\u5bc6\u7801\u91cc\u9762\u6ca1\u6709\u5927\u5199\u5b57\u6bcd\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)hasSmallLetters, (String)"\u5bc6\u7801\u91cc\u9762\u6ca1\u6709\u5c0f\u5199\u5b57\u6bcd\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)hasNumbers, (String)"\u5bc6\u7801\u91cc\u9762\u6ca1\u6709\u6570\u5b57\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)hasSpecialChars, (String)"\u5bc6\u7801\u91cc\u9762\u6ca1\u6709\u7279\u6b8a\u5b57\u7b26\uff01", (Object[])new Object[0]);
    }

    private void validationPosition(UserDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty((Collection)dto.getPositionList())) {
            return;
        }
        List flag = dto.getPositionList().stream().filter(o -> o.getPrimaryFlag() == true).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(flag), (String)"\u5fc5\u987b\u6709\u4e00\u4e2a\u4e3b\u804c\u4f4d!", (Object[])new Object[0]);
    }

    public List<UserVo> findByUserCodes(Set<String> userCodes) {
        if (CollectionUtils.isEmpty(userCodes)) {
            return new ArrayList<UserVo>(0);
        }
        List<UserEntity> userEntities = this.userRepository.findByUserCodes(TenantUtils.getTenantCode(), userCodes);
        if (CollectionUtils.isEmpty(userEntities)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(userEntities, UserEntity.class, UserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

