package com.biz.crm.mdm.business.user.local.authority;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @Author: heguanyun
 * @Date: 2022/4/14 19:18
 * @description:
 */
@Component("userSelectAuthorityModeRegister")
public class UserAuthorityModeRegister implements SelectAuthorityModeRegister {
  @Override
  public String modeKey() {
    return "userAuthorityModeRegister";
  }

  @Override
  public String modeName() {
    return "查看当前登录人账号创建的数据";
  }

  @Override
  public String controlKey() {
    return "userAuthorityModeRegister";
  }

  @Override
  public int sort() {
    return 9;
  }

  @Override
  public String groupCode() {
    return "user_group";
  }

  @Override
  public boolean isArrayValue() {
    return false;
  }

  @Override
  public boolean isStaticValue() {
    return false;
  }

  @Override
  public Class<?> modeValueClass() {
    return String.class;
  }

  @Override
  public Object staticValue(String[] strings) {
    return null;
  }

  @Override
  public Object dynamicValue(UserIdentity loginDetails, String s) {
    String identityType = loginDetails.getIdentityType();
    //如果不是后台管理用户，就不按职位字段进行权限控制
    if (!StringUtils.equals(identityType, "u")) {
      return null;
    }
    return loginDetails.getAccount();
  }

  @Override
  public String converterKey() {
    return "chartEqualMarsAuthorityValueAstConverter";
  }
}
