/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.mdm.business.user.local.entity.UserPositionEntity;
import com.biz.crm.mdm.business.user.local.mapper.UserPositionMapper;
import com.biz.crm.mdm.business.user.sdk.dto.UserPositionPageDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class UserPositionRepository
extends ServiceImpl<UserPositionMapper, UserPositionEntity> {
    public Page<UserPositionVo> findByConditions(Pageable pageable, @Param(value="dto") UserPositionPageDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto = Optional.ofNullable(dto).orElse(new UserPositionPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((UserPositionMapper)this.baseMapper).findByConditions((Page<UserPositionPageDto>)page, dto);
    }

    public UserPositionEntity findById(String id) {
        return (UserPositionEntity)((Object)((UserPositionMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<UserPositionEntity> findByUserName(String tenantCode, String userName) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(UserPositionEntity::getUserName, (Object)userName)).list();
    }

    public List<UserPositionEntity> findByPositionCodeIn(String tenantCode, Collection<String> positionCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(UserPositionEntity::getPositionCode, positionCodes)).list();
    }

    public List<UserPositionEntity> findByUserNames(String tenantCode, Collection<String> userNames) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(UserPositionEntity::getUserName, userNames)).list();
    }

    public void deleteByUserNames(String tenantCode, Collection<String> userNames) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(UserPositionEntity::getUserName, userNames)).remove();
    }

    public void deleteByPositionCodes(String tenantCode, Collection<String> positionCodes) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(UserPositionEntity::getPositionCode, positionCodes)).remove();
    }

    public void updateCurrentFlagFalseByUserName(String tenantCode, String userName) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(UserPositionEntity::getUserName, (Object)userName)).eq(UserPositionEntity::getCurrentFlag, (Object)Boolean.TRUE)).set(UserPositionEntity::getCurrentFlag, (Object)Boolean.FALSE)).update();
    }

    public void updateCurrentFlagTrueByUserNameAndPositionCode(String tenantCode, String userName, String positionCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(UserPositionEntity::getUserName, (Object)userName)).eq(UserPositionEntity::getPositionCode, (Object)positionCode)).set(UserPositionEntity::getCurrentFlag, (Object)Boolean.TRUE)).update();
    }

    public List<UserPositionEntity> findAllUser(String tenantCode) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }
}

