/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.user.local.entity.UserEntity;
import com.biz.crm.mdm.business.user.local.mapper.UserMapper;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserPageDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class UserRepository
extends ServiceImpl<UserMapper, UserEntity> {
    public Page<UserVo> findByConditions(Pageable pageable, @Param(value="dto") UserPageDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto = Optional.ofNullable(dto).orElse(new UserPageDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((UserMapper)this.baseMapper).findByConditions((Page<UserPageDto>)page, dto);
    }

    public UserEntity findByUserCode(@Param(value="tenantCode") String tenantCode, @Param(value="userCode") String userCode) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq(UserEntity::getUserCode, (Object)userCode);
        return (UserEntity)((Object)((UserMapper)this.baseMapper).selectOne((Wrapper)wrapper));
    }

    public UserEntity findByUserName(@Param(value="tenantCode") String tenantCode, @Param(value="userName") String userName) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq(UserEntity::getUserName, (Object)userName);
        return (UserEntity)((Object)((UserMapper)this.baseMapper).selectOne((Wrapper)wrapper));
    }

    public UserEntity findByUserNameCoverDel(@Param(value="tenantCode") String tenantCode, @Param(value="userName") String userName) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UserEntity::getUserName, (Object)userName);
        return (UserEntity)((Object)((UserMapper)this.baseMapper).selectOne((Wrapper)wrapper));
    }

    public List<UserEntity> findByUserNames(@Param(value="tenantCode") String tenantCode, @Param(value="userNames") Collection<String> userNames) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.in(UserEntity::getUserName, userNames);
        return ((UserMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public List<UserEntity> findByUserPhone(@Param(value="tenantCode") String tenantCode, @Param(value="userPhone") String userPhone) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UserEntity::getUserPhone, (Object)userPhone);
        return ((UserMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public List<UserEntity> findByEmail(@Param(value="tenantCode") String tenantCode, @Param(value="email") String email) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq(UserEntity::getEmail, (Object)email);
        return ((UserMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public List<UserEntity> findByIdentityCardNumber(@Param(value="tenantCode") String tenantCode, @Param(value="identityCardNumber") String identityCardNumber) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq(UserEntity::getIdentityCardNumber, (Object)identityCardNumber);
        return ((UserMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public List<UserEntity> findByIds(@Param(value="ids") List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updatePasswordByIds(List<String> ids, String password) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UserEntity::getUserPassword, (Object)password)).set(UserEntity::getForceChangePassword, (Object)Boolean.FALSE)).update();
    }

    public List<UserEntity> findByUserNamesAndUserType(String tenantCode, Set<String> userNames, String userType) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UserEntity::getUserType, (Object)userType)).in(UserEntity::getUserName, userNames)).list();
        return list;
    }

    public Set<String> findUserNamesByUserConditionDto(UserConditionDto dto) {
        return ((UserMapper)this.baseMapper).findUserNamesByUserConditionDto(dto);
    }
}

