/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.user.local.entity.UserPositionEntity;
import com.biz.crm.mdm.business.user.local.repository.UserPositionRepository;
import com.biz.crm.mdm.business.user.sdk.dto.UserPositionDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserPositionPageDto;
import com.biz.crm.mdm.business.user.sdk.event.UserPositionEventListener;
import com.biz.crm.mdm.business.user.sdk.service.UserPositionVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserPositionVoServiceImpl
implements UserPositionVoService {
    @Autowired(required=false)
    private UserPositionRepository userPositionRepository;
    @Autowired(required=false)
    @Lazy
    private List<UserPositionEventListener> userPositionEventListeners;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public Page<UserPositionVo> findByConditions(Pageable pageable, UserPositionPageDto dto) {
        return this.userPositionRepository.findByConditions(pageable, dto);
    }

    public UserPositionVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        UserPositionEntity entity = this.userPositionRepository.findById(id);
        if (entity == null) {
            return null;
        }
        return (UserPositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, UserPositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<UserPositionVo> findByUserName(String tenantCode, String userName) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || StringUtils.isBlank((CharSequence)userName)) {
            return new ArrayList<UserPositionVo>();
        }
        List<UserPositionEntity> entities = this.userPositionRepository.findByUserName(tenantCode, userName);
        if (CollectionUtils.isEmpty(entities)) {
            return new ArrayList<UserPositionVo>();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, UserPositionEntity.class, UserPositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void create(UserPositionDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        UserPositionEntity entity = (UserPositionEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, UserPositionEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.userPositionRepository.save((Object)entity);
        if (CollectionUtils.isNotEmpty(this.userPositionEventListeners)) {
            UserPositionVo vo = (UserPositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, UserPositionVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.userPositionEventListeners.forEach(event -> event.onCreate(vo));
        }
    }

    @Transactional
    public void update(UserPositionDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserPositionEntity oldEntity = this.userPositionRepository.findById(dto.getId());
        Validate.notNull((Object)((Object)oldEntity), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        UserPositionEntity entity = (UserPositionEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, UserPositionEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.userPositionRepository.updateById((Object)entity);
        if (CollectionUtils.isNotEmpty(this.userPositionEventListeners)) {
            UserPositionVo oldVo = (UserPositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, UserPositionVo.class, HashSet.class, ArrayList.class, new String[0]);
            UserPositionVo newVo = (UserPositionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, UserPositionVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.userPositionEventListeners.forEach(event -> event.onUpdate(oldVo, newVo));
        }
    }

    public void deleteByUserNames(Collection<String> userNames) {
        if (CollectionUtils.isEmpty(userNames)) {
            return;
        }
        this.userPositionRepository.deleteByUserNames(TenantUtils.getTenantCode(), userNames);
    }

    public void rebindByUserName(String userName, String primaryPositionCode, List<String> positionCodeList) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return;
        }
        this.userPositionRepository.deleteByUserNames(TenantUtils.getTenantCode(), Collections.singletonList(userName));
        HashSet<String> positionCodeSet = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)primaryPositionCode)) {
            positionCodeSet.add(primaryPositionCode);
        }
        if (CollectionUtils.isNotEmpty(positionCodeList)) {
            this.userPositionRepository.deleteByPositionCodes(TenantUtils.getTenantCode(), positionCodeList);
            if (CollectionUtils.isEmpty(positionCodeSet)) {
                primaryPositionCode = positionCodeList.get(0);
            }
            positionCodeSet.addAll(positionCodeList);
        }
        if (CollectionUtils.isEmpty(positionCodeSet)) {
            return;
        }
        ArrayList<UserPositionEntity> list = new ArrayList<UserPositionEntity>();
        for (String positionCode : positionCodeSet) {
            UserPositionEntity entity = new UserPositionEntity();
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setUserName(userName);
            entity.setPositionCode(positionCode);
            if (StringUtils.equals((CharSequence)primaryPositionCode, (CharSequence)positionCode)) {
                entity.setPrimaryFlag(Boolean.TRUE);
                entity.setCurrentFlag(Boolean.TRUE);
            } else {
                entity.setPrimaryFlag(Boolean.FALSE);
                entity.setCurrentFlag(Boolean.FALSE);
            }
            list.add(entity);
        }
        this.userPositionRepository.saveBatch(list);
    }

    @Transactional
    public void updateCurrentFlagPosition(String userName, String currentFlagPositionCode) {
        this.userPositionRepository.updateCurrentFlagFalseByUserName(TenantUtils.getTenantCode(), userName);
        this.userPositionRepository.updateCurrentFlagTrueByUserNameAndPositionCode(TenantUtils.getTenantCode(), userName, currentFlagPositionCode);
    }

    public List<UserPositionVo> findAllUser(String tenantCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return new ArrayList<UserPositionVo>();
        }
        List<UserPositionEntity> entities = this.userPositionRepository.findAllUser(tenantCode);
        if (CollectionUtils.isEmpty(entities)) {
            return new ArrayList<UserPositionVo>();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, UserPositionEntity.class, UserPositionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Set<UserPositionVo> findByPositionCodeIn(Collection<String> positionCodes) {
        List<UserPositionEntity> userPositionList = this.userPositionRepository.findByPositionCodeIn(TenantUtils.getTenantCode(), positionCodes);
        HashSet<UserPositionVo> set = new HashSet<UserPositionVo>();
        for (UserPositionEntity entity : userPositionList) {
            UserPositionVo userPositionVo = (UserPositionVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, UserPositionVo.class, HashSet.class, ArrayList.class, new String[0]);
            set.add(userPositionVo);
        }
        return set;
    }
}

