/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.LoginFromTypeEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.user.local.entity.UserRelWeChatEntity;
import com.biz.crm.mdm.business.user.local.repository.UserRelWeChatRepository;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelWeChatDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelWeChatPageDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserWeChatBindDto;
import com.biz.crm.mdm.business.user.sdk.enums.UserTypeEnum;
import com.biz.crm.mdm.business.user.sdk.event.UserRelWeChatEventListener;
import com.biz.crm.mdm.business.user.sdk.service.UserRelWeChatVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelWeChatVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserRelWeChatVoServiceImpl
implements UserRelWeChatVoService {
    @Autowired(required=false)
    private UserRelWeChatRepository userRelWeChatRepository;
    @Autowired(required=false)
    @Lazy
    private List<UserRelWeChatEventListener> userRelWeChatEventListeners;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private UserVoService userVoService;

    public Page<UserRelWeChatVo> findByConditions(Pageable pageable, UserRelWeChatPageDto dto) {
        return this.userRelWeChatRepository.findByConditions(pageable, dto);
    }

    public UserRelWeChatVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        UserRelWeChatEntity entity = this.userRelWeChatRepository.findById(id);
        if (entity == null) {
            return null;
        }
        return (UserRelWeChatVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, UserRelWeChatVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void create(UserRelWeChatDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        UserRelWeChatEntity entity = (UserRelWeChatEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, UserRelWeChatEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.userRelWeChatRepository.save((Object)entity);
        if (CollectionUtils.isNotEmpty(this.userRelWeChatEventListeners)) {
            UserRelWeChatVo vo = (UserRelWeChatVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, UserRelWeChatVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.userRelWeChatEventListeners.forEach(event -> event.onCreate(vo));
        }
    }

    @Transactional
    public void update(UserRelWeChatDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserRelWeChatEntity oldEntity = this.userRelWeChatRepository.findById(dto.getId());
        Validate.notNull((Object)((Object)oldEntity), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        UserRelWeChatEntity entity = (UserRelWeChatEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, UserRelWeChatEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.userRelWeChatRepository.updateById((Object)entity);
        if (CollectionUtils.isNotEmpty(this.userRelWeChatEventListeners)) {
            UserRelWeChatVo oldVo = (UserRelWeChatVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, UserRelWeChatVo.class, HashSet.class, ArrayList.class, new String[0]);
            UserRelWeChatVo newVo = (UserRelWeChatVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, UserRelWeChatVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.userRelWeChatEventListeners.forEach(event -> event.onUpdate(oldVo, newVo));
        }
    }

    @Transactional
    public void deleteByUserNames(List<String> userNames) {
        if (CollectionUtils.isEmpty(userNames)) {
            return;
        }
        this.userRelWeChatRepository.deleteByUserNames(TenantUtils.getTenantCode(), userNames);
    }

    public List<UserRelWeChatVo> findByUserRelWeChatDto(UserRelWeChatDto dto) {
        List<UserRelWeChatEntity> entities = this.userRelWeChatRepository.findByUserRelWeChatDto(TenantUtils.getTenantCode(), dto);
        if (CollectionUtils.isEmpty(entities)) {
            return new ArrayList<UserRelWeChatVo>();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, UserRelWeChatEntity.class, UserRelWeChatVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void createByUserWeChatBindDto(UserWeChatBindDto dto) {
        List<UserRelWeChatEntity> existCheck;
        this.createValidation(dto);
        UserWeChatBindDto queryDto = new UserWeChatBindDto();
        queryDto.setOriginModule(dto.getOriginModule());
        queryDto.setOpenId(dto.getOpenId());
        List<UserRelWeChatEntity> collect = this.userRelWeChatRepository.findByUserWeChatBindDto(queryDto);
        if (CollectionUtils.isNotEmpty(collect)) {
            collect = collect.stream().filter(x -> !dto.getUserName().equals(x.getUserName())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(collect)) {
            this.userRelWeChatRepository.removeByIds(collect.stream().map(UuidEntity::getId).collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty(existCheck = this.userRelWeChatRepository.findByUserWeChatBindDto(dto))) {
            UserRelWeChatEntity entity = (UserRelWeChatEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, UserRelWeChatEntity.class, HashSet.class, ArrayList.class, new String[0]));
            entity.setLoginStatus(Boolean.TRUE);
            this.userRelWeChatRepository.save((Object)entity);
        } else {
            UserRelWeChatEntity entity = existCheck.get(0);
            entity.setLoginStatus(Boolean.TRUE);
            this.userRelWeChatRepository.updateById((Object)existCheck.get(0));
        }
    }

    public List<UserRelWeChatVo> findByOpenid(String openid) {
        if (StringUtils.isBlank((CharSequence)openid)) {
            return new ArrayList<UserRelWeChatVo>(0);
        }
        List<UserRelWeChatEntity> entities = this.userRelWeChatRepository.findByOpenid(TenantUtils.getTenantCode(), openid);
        if (CollectionUtils.isEmpty(entities)) {
            return new ArrayList<UserRelWeChatVo>();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, UserRelWeChatEntity.class, UserRelWeChatVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<UserRelWeChatVo> findByUserName(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return new ArrayList<UserRelWeChatVo>(0);
        }
        List<UserRelWeChatEntity> entities = this.userRelWeChatRepository.findByUserName(TenantUtils.getTenantCode(), userName);
        if (CollectionUtils.isEmpty(entities)) {
            return new ArrayList<UserRelWeChatVo>();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, UserRelWeChatEntity.class, UserRelWeChatVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidation(UserWeChatBindDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setId(null);
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOpenId(), (String)"\u7f3a\u5931openId", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOriginModule(), (String)"\u7f3a\u5931\u5173\u8054\u5c0f\u7a0b\u5e8f\u6a21\u5757", (Object[])new Object[0]);
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        UserVo userVo = this.userVoService.findByUserName(loginDetails.getAccount());
        Validate.notNull((Object)userVo, (String)"\u7528\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        dto.setUserName(userVo.getUserName());
        Boolean uniqueCheck = Boolean.TRUE;
        if (LoginFromTypeEnum.SFA_MINI.getValue().equals(dto.getOriginModule())) {
            Validate.isTrue((boolean)UserTypeEnum.USER.getCode().equals(userVo.getUserType()), (String)"\u975e\u4f01\u4e1a\u7528\u6237\u4e0d\u80fd\u7ed1\u5b9aSFA\u5c0f\u7a0b\u5e8f", (Object[])new Object[0]);
        } else if (LoginFromTypeEnum.DMS_MINI.getValue().equals(dto.getOriginModule())) {
            Validate.isTrue((boolean)UserTypeEnum.CUSTOMER.getCode().equals(userVo.getUserType()), (String)"\u975e\u5ba2\u6237\u7528\u6237\u4e0d\u80fd\u7ed1\u5b9aDMS\u5c0f\u7a0b\u5e8f", (Object[])new Object[0]);
        } else {
            throw new IllegalArgumentException("\u5c0f\u7a0b\u5e8f\u6a21\u5757\u4e0d\u5b58\u5728");
        }
        if (Boolean.TRUE.equals(uniqueCheck)) {
            UserWeChatBindDto queryDto = new UserWeChatBindDto();
            queryDto.setOriginModule(dto.getOriginModule());
            queryDto.setUserName(dto.getUserName());
            List<UserRelWeChatEntity> entities = this.userRelWeChatRepository.findByUserWeChatBindDto(queryDto);
            if (CollectionUtils.isNotEmpty(entities)) {
                entities = entities.stream().filter(x -> !dto.getOpenId().equals(x.getOpenId())).collect(Collectors.toList());
            }
            Validate.isTrue((boolean)CollectionUtils.isEmpty(entities), (String)"\u8be5\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u5fae\u4fe1\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a", (Object[])new Object[0]);
        }
    }
}

