/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.user.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.enums.LockStateEnum;
import com.biz.crm.mdm.business.user.sdk.enums.UserTypeEnum;
import com.biz.crm.mdm.business.user.sdk.service.UserRelWeChatVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserValidityCheckService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelWeChatVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserValidityCheckServiceImpl
implements UserValidityCheckService {
    @Autowired(required=false)
    private UserVoService userVoService;
    @Autowired(required=false)
    private UserRelWeChatVoService userRelWeChatVoService;

    public UserVo verificationManageByAccount(String account) {
        UserVo userVo = this.userVoService.findByUserName(account);
        this.verificationManage(userVo);
        return userVo;
    }

    public UserVo verificationManageByPhone(String phone) {
        UserVo userVo = this.userVoService.findByPhone(phone);
        this.verificationManage(userVo);
        return userVo;
    }

    public UserVo verificationManageByOpenid(String openid) {
        List byUserRelWeChatDto = this.userRelWeChatVoService.findByOpenid(openid);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)byUserRelWeChatDto) ? 1 : 0) != 0, (String)"\u5fae\u4fe1\u672a\u7ed1\u5b9a\u4efb\u4f55\u7528\u6237\uff01", (Object[])new Object[0]);
        Validate.isTrue((byUserRelWeChatDto.size() == 1 ? 1 : 0) != 0, (String)"\u5fae\u4fe1\u7ed1\u5b9a\u4e86\u591a\u4e2a\u7528\u6237\uff01", (Object[])new Object[0]);
        UserRelWeChatVo one = (UserRelWeChatVo)byUserRelWeChatDto.get(0);
        List userRelWeChatVos = this.userRelWeChatVoService.findByUserName(one.getUserName());
        Validate.isTrue((userRelWeChatVos.size() == 1 ? 1 : 0) != 0, (String)"\u7528\u6237\u7ed1\u5b9a\u4e86\u591a\u4e2a\u5fae\u4fe1\uff0c\u8bf7\u5148\u5728\u540e\u53f0\u89e3\u7ed1\uff01", (Object[])new Object[0]);
        UserVo userVo = this.userVoService.findByUserName(one.getUserName());
        this.verificationManage(userVo);
        return userVo;
    }

    private void verificationManage(UserVo userVo) {
        Validate.notNull((Object)userVo, (String)"\u5f53\u524d\u7cfb\u7edf\u4e0d\u5b58\u5728\u6b64\u7528\u6237\uff0c\u8bf7\u5148\u6ce8\u518c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)userVo.getUserType(), (String)"\u672a\u77e5\u7528\u6237\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)UserTypeEnum.USER.getCode().equals(userVo.getUserType()), (String)"\u53ea\u6709\u4f01\u4e1a\u7528\u6237\u624d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(userVo.getEnableStatus()), (String)"\u5f53\u524d\u7528\u6237\u5df2\u7981\u7528\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)LockStateEnum.UNLOCK.getCode().equals(userVo.getLockState()), (String)"\u5f53\u524d\u7528\u6237\u5df2\u9501\u5b9a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(userVo.getDelFlag()), (String)"\u6b64\u624b\u673a\u53f7\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        try {
            String fmt = "yyyy-MM-dd HH:mm:ss";
            Date now = new Date();
            if (StringUtils.isNotEmpty((CharSequence)userVo.getStartTime())) {
                Validate.isTrue((now.compareTo(DateUtils.parseDate((String)userVo.getStartTime(), (String[])new String[]{fmt})) >= 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u672a\u751f\u6548", (Object[])new Object[0]);
            }
            if (StringUtils.isNotEmpty((CharSequence)userVo.getEndTime())) {
                Validate.isTrue((now.compareTo(DateUtils.parseDate((String)userVo.getEndTime(), (String[])new String[]{fmt})) <= 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u5df2\u5931\u6548", (Object[])new Object[0]);
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

