package com.biz.crm.mdm.business.user.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.sdk.dto.InspectionAuthorityDto;
import com.biz.crm.mdm.business.user.sdk.service.InspectionAuthorityService;
import com.biz.crm.mdm.business.user.sdk.vo.InspectionAuthorityVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName InspectionAuthorityController
 * @Description 稽查权限 controller
 * @AUTHOR WangJJ
 * @DATE 2023/6/16 16:51
 **/
@Slf4j
@Api(tags = "稽查权限")
@RestController
@RequestMapping(value = {"/v1/inspectionAuthority/inspectionAuthority"})
public class InspectionAuthorityController {

    @Autowired(required = false)
    private InspectionAuthorityService inspectionAuthorityService;


    /**
     * 获取 稽查权限字段
     *
     * @param dto 查询条件
     * @return
     */
    @ApiOperation(value = "获取 稽查权限字段")
    @GetMapping(value = {"/listByConditions"})
    public Result<List<InspectionAuthorityVo>> listByConditions(@ApiParam(name = "dto",value = "查询参数") InspectionAuthorityDto dto) {
        try {
            return Result.ok(this.inspectionAuthorityService.listByConditions(dto));
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 保存稽查权限字段
     *
     * @param dtos 保存数据
     * @return
     */
    @ApiOperation(value = "保存稽查权限字段")
    @PostMapping(value = {"/savaOrUpdate"})
    public Result<?> savaOrUpdate(@ApiParam(name = "dtos",value = "保存数据") @RequestBody List<InspectionAuthorityDto> dtos) {
        try {
            this.inspectionAuthorityService.savaOrUpdate(dtos);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


}
