package com.biz.crm.mdm.business.user.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelateWarehouseBindDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelateWarehouseDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelateWarehouseSearchDto;
import com.biz.crm.mdm.business.user.sdk.service.UserRelateWarehouseService;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelateWarehouseVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import oracle.jdbc.proxy.annotation.Post;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author chuyi
 * @version 1.0
 * @description: TODO
 * @date 2023/6/25 11:03
 */
@Slf4j
@Api(tags = "企业用户: UserRelateWarehousr:关联仓库")
@RestController
@RequestMapping(value = {"/v1/user/userRelateWarehouse"})
public class UserRelateWarehouseController {
    @Autowired(required = false)
    private UserRelateWarehouseService userRelateWarehouseService;

    @ApiOperation(value = "企业用户仓库绑定")
    @PatchMapping(value = {"/bind"})
    public Result<?> bind(@RequestBody UserRelateWarehouseDto dto){
        try {
            this.userRelateWarehouseService.bind(dto);
            return Result.ok("操作成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "企业用户仓库解绑")
    @PatchMapping(value = {"/unbind"})
    public Result<?> unbind(@RequestBody UserRelateWarehouseDto dto){
        try {
            this.userRelateWarehouseService.unbind(dto);
            return Result.ok("操作成功");
        } catch (RuntimeException e) {
           log.error(e.getMessage(),e);
           return Result.error(e.getMessage());
        }

    }

    /**
     * 查询企业用户与仓库绑定
     */
    @ApiOperation(value = "查询企业用户与仓库绑定")
    @PostMapping("findByCode")
    public Result<List<UserRelateWarehouseVo>> findByCode(@RequestBody UserRelateWarehouseSearchDto dto){
        try {
            List<UserRelateWarehouseVo> list =this.userRelateWarehouseService.findByCode(dto);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }
}
