package com.biz.crm.mdm.business.user.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @ClassName InspectionAuthorityEntity
 * @Description 稽查权限表
 * @AUTHOR WangJJ
 * @DATE 2023/6/16 16:36
 **/
@ApiModel(value = "InspectionAuthorityEntity", description = "稽查权限表")
@Data
@Entity
@Table(name = "mdm_inspection_authority")
@TableName(value = "mdm_inspection_authority")
@org.hibernate.annotations.Table(appliesTo = "mdm_inspection_authority", comment = "稽查权限表")
public class InspectionAuthorityEntity extends TenantFlagOpEntity {

    @ApiModelProperty("角色编码")
    @TableField(value = "role_code")
    @Column(name = "role_code", length = 64, columnDefinition = "varchar(64) COMMENT '角色编码'")
    private String roleCode;

    @ApiModelProperty("字段编码")
    @TableField(value = "column_code")
    @Column(name = "column_code", length = 64, columnDefinition = "varchar(64) COMMENT '字段编码'")
    private String columnCode;

    @ApiModelProperty("字段名称")
    @TableField(value = "column_name")
    @Column(name = "column_name", length = 128, columnDefinition = "varchar(128) COMMENT '字段名称'")
    private String columnName;

    @ApiModelProperty("类型")
    @TableField(value = "type")
    @Column(name = "type", length = 10, columnDefinition = "varchar(10) COMMENT '类型'")
    private String type;


}
