package com.biz.crm.mdm.business.user.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.bizunited.nebula.common.entity.TenantEntity;
import com.bizunited.nebula.common.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.List;

/**
 * 企业用户关联仓库(UserRelateWarehouseEntity)实体类
 *
 * @author chuyi
 * @since 2021-11-01 09:30:14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_user_r_warehouse")
@Table(
        name = "mdm_user_r_warehouse",
        indexes = {
                @Index(
                        name = "mdm_user_r_warehouse_index",
                        columnList = "tenant_code,user_code,warehouse_code",
                        unique = true),
        })
@ApiModel(value = "UserRelateWarehouseEntity",description = "企业用户关联仓库")
@org.hibernate.annotations.Table(appliesTo = "mdm_user_r_warehouse", comment = "企业用户关联仓库")
public class UserRelateWarehouseEntity extends TenantFlagOpEntity {

    private static final long serialVersionUID = -2957610406564703791L;

    /** 企业用户编码 */
    @ApiModelProperty("企业用户编码")
    @TableField(value = "user_code")
    @Column(name = "user_code", length = 32, columnDefinition = "varchar(32) COMMENT '企业用户编码'")
    private String userCode;

    /** 仓库编码 */
    @ApiModelProperty("仓库编码")
    @TableField(value = "warehouse_code")
    @Column(name = "warehouse_code", length = 32, columnDefinition = "varchar(32) COMMENT '仓库编码'")
    private String warehouseCode;
}
