package com.biz.crm.mdm.business.user.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.user.local.entity.InspectionAuthorityEntity;
import com.biz.crm.mdm.business.user.local.mapper.InspectionAuthorityMapper;
import com.biz.crm.mdm.business.user.sdk.dto.InspectionAuthorityDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

/**
 * @ClassName InspectionAuthorityRepository
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/16 16:48
 **/
@Component
public class InspectionAuthorityRepository extends ServiceImpl<InspectionAuthorityMapper, InspectionAuthorityEntity> {


    public List<InspectionAuthorityEntity> listByConditions(InspectionAuthorityDto dto){
        if (Objects.isNull(dto)){
            return Lists.newArrayList();
        }
        List<InspectionAuthorityEntity> list = this.lambdaQuery()
                .eq(InspectionAuthorityEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(InspectionAuthorityEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(StringUtils.isNotBlank(dto.getType()),InspectionAuthorityEntity::getType,dto.getType())
                .eq(StringUtils.isNotBlank(dto.getColumnCode()),InspectionAuthorityEntity::getColumnCode, dto.getColumnCode())
                .eq(StringUtils.isNotBlank(dto.getColumnName()),InspectionAuthorityEntity::getColumnName, dto.getColumnName())
                .eq(StringUtils.isNotBlank(dto.getRoleCode()),InspectionAuthorityEntity::getRoleCode, dto.getRoleCode())
                .list();
        if (CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        return list;
    }

    /**
     * 物理删除
     * @param roleCodes
     */
    public void removeByRoleCode(List<String> roleCodes){
        if (CollectionUtils.isEmpty(roleCodes)){
            return;
        }
        this.lambdaUpdate()
                .in(InspectionAuthorityEntity::getRoleCode,roleCodes)
                .remove();
    }

}
