package com.biz.crm.mdm.business.user.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.user.local.entity.UserEntity;
import com.biz.crm.mdm.business.user.local.entity.UserRelateWarehouseEntity;
import com.biz.crm.mdm.business.user.local.mapper.UserRelateWarehouseMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author 28689
 * @version 1.0
 * @description: TODO
 * @date 2023/6/25 11:17
 */
@Component
public class UserRelateWarehouseRepository extends ServiceImpl<UserRelateWarehouseMapper, UserRelateWarehouseEntity> {
    public List<UserRelateWarehouseEntity> findByUserCodesAndWarehoseCodes
            (String userCode, List<String> warehouseCodeList) {
         return this.lambdaQuery()
                 .eq(UserRelateWarehouseEntity::getTenantCode, TenantUtils.getTenantCode())
                 .eq(UserRelateWarehouseEntity::getUserCode,userCode)
                 .in(UserRelateWarehouseEntity::getWarehouseCode,warehouseCodeList)
                 .list();
    }

    public List<UserRelateWarehouseEntity> findByids(List<String> idList) {
        return this.lambdaQuery()
                .eq(UserRelateWarehouseEntity::getTenantCode,TenantUtils.getTenantCode())
                .in(UserRelateWarehouseEntity::getId,idList)
                .list();
    }

    public void deleteByIdsAndTenantCode(String userCode,List<String> WarehouseCodeList, String tenantCode) {
        this.lambdaUpdate().eq(UserRelateWarehouseEntity::getTenantCode,tenantCode)
                .eq(UserRelateWarehouseEntity::getUserCode,userCode)
                .in(UserRelateWarehouseEntity::getWarehouseCode,WarehouseCodeList)
                .remove();
    }

    public List<String> findByCode(UserEntity user) {
        return baseMapper.findByCode(user);
    }
}
